/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class EarImplPlugin
extends Plugin {
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static EarImplPlugin ourInstance;

    public EarImplPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public static EarImplPlugin getDefault() {
        return ourInstance;
    }

    public static void revisit() {
    }

    public static void revisit(String msg) {
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        EarImplPlugin instance = EarImplPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        EarImplPlugin.log(1, text);
    }

    public static void logError(String text) {
        EarImplPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        EarImplPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        EarImplPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        EarImplPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        EarImplPlugin instance = EarImplPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            EarImplPlugin.log(type, text, new Throwable());
        } else {
            EarImplPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        EarImplPlugin instance = EarImplPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

