/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear;

import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.UriResolver;
import com.tssap.j2ee.core.descriptor.UserInterface;
import com.tssap.j2ee.core.ear.ConnectorModule;
import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ear.JavaModule;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.descriptor.DescriptorDocumentImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ear.AbstractModule;
import com.tssap.j2ee.internal.core.ear.ConnectorModuleImpl;
import com.tssap.j2ee.internal.core.ear.EarChildOrder;
import com.tssap.j2ee.internal.core.ear.EarImplPlugin;
import com.tssap.j2ee.internal.core.ear.EarProjectImpl;
import com.tssap.j2ee.internal.core.ear.EjbModuleImpl;
import com.tssap.j2ee.internal.core.ear.JavaModuleImpl;
import com.tssap.j2ee.internal.core.ear.SecurityRoleImpl;
import com.tssap.j2ee.internal.core.ear.UserInterfaceImpl;
import com.tssap.j2ee.internal.core.ear.WebModuleImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Element;

public final class EarImpl
extends DescriptorDocumentImpl
implements Ear {
    public static final String PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    private static final String DTD_PATH = "templates/application_1_3.dtd";
    private static String ourDtd;
    private UserInterface myUserInterface;
    private Map myConnectorModules;
    private Map myEjbModules;
    private Map myJavaModules;
    private Map myWebModules;
    private Map mySecurityRoles;
    private EarProjectImpl myProject;

    public EarImpl(IFile file, EarProjectImpl project) {
        super(file, (DescriptorDeltaListener)project);
        this.myProject = project;
        this.myUserInterface = new UserInterfaceImpl((DescriptorEntityImpl)this, this.getElement(), EarChildOrder.APPLICATION, "application");
    }

    public String toString() {
        return "Ear \"" + this.getUserInterface().getDisplayName() + "\"";
    }

    public void delete() {
        try {
            this.getFile().delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to delete file [" + this.getFile() + "]", ce);
        }
    }

    public String getSpecVersion() {
        return "1.3";
    }

    public UserInterface getUserInterface() {
        return this.myUserInterface;
    }

    public String getDescription() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"description");
    }

    public boolean canSetDescription(String description) {
        return this.isRecognized();
    }

    public void setDescription(String description) {
        if (!this.canSetDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDescription(), (Object)description)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EarChildOrder.APPLICATION, (String)"description", (String)description);
        this.changed((DescriptorEntity)this);
    }

    protected void readSecurityRoles() {
        if (this.mySecurityRoles == null) {
            this.mySecurityRoles = new HashMap();
            Element[] roles = DomUtils.getChildElements((Element)this.getElement(), (String)"security-role");
            int i = 0;
            while (i < roles.length) {
                SecurityRoleImpl role = new SecurityRoleImpl(this, roles[i]);
                String name = role.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoles.containsKey(name)) {
                    this.mySecurityRoles.put(name, role);
                }
                ++i;
            }
        }
    }

    protected void updateSecurityRole(String name) {
        SecurityRole role;
        if (this.mySecurityRoles != null && (role = (SecurityRole)this.mySecurityRoles.remove(name)) != null && role.isValid()) {
            this.mySecurityRoles.put(role.getName(), role);
        }
    }

    public SecurityRole[] getSecurityRoles() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSecurityRoles();
        if (this.mySecurityRoles.isEmpty()) {
            return null;
        }
        Collection roles = this.mySecurityRoles.values();
        return roles.toArray(new SecurityRole[roles.size()]);
    }

    public SecurityRole getSecurityRole(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSecurityRoles();
        return (SecurityRole)this.mySecurityRoles.get(name);
    }

    public boolean canCreateSecurityRole(String name, String description) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readSecurityRoles();
        return !DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoles.containsKey(name);
    }

    public SecurityRole createSecurityRole(String name, String description) {
        if (!this.canCreateSecurityRole(name, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element roleElement = DomUtils.createChildElement((Element)this.getElement(), (String[])EarChildOrder.APPLICATION, (String)"security-role");
        DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EarChildOrder.SECURITY_ROLE, (String)"role-name", (String)name);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EarChildOrder.SECURITY_ROLE, (String)"description", (String)description);
        }
        SecurityRoleImpl role = new SecurityRoleImpl(this, roleElement);
        this.mySecurityRoles.put(role.getName(), role);
        this.added((DescriptorEntity)role);
        return role;
    }

    protected void updateConnectorModule(String uri) {
        ConnectorModule module;
        if (this.myConnectorModules != null && (module = (ConnectorModule)this.myConnectorModules.remove(uri)) != null && module.isValid()) {
            this.myConnectorModules.put(module.getUri(), module);
        }
    }

    public ConnectorModule[] getConnectorModules() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        if (this.myConnectorModules.isEmpty()) {
            return null;
        }
        Collection modules = this.myConnectorModules.values();
        return modules.toArray(new ConnectorModule[modules.size()]);
    }

    public ConnectorModule getConnectorModule(String uri) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        return (ConnectorModule)this.myConnectorModules.get(uri);
    }

    public boolean canCreateConnectorModule(String uri, String altDd) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readModules();
        return !DescriptorEntityImpl.isNull((String)uri) && !this.myConnectorModules.containsKey(uri);
    }

    public ConnectorModule createConnectorModule(String uri, String altDd) {
        if (!this.canCreateConnectorModule(uri, altDd)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element moduleElement = DomUtils.createChildElement((Element)this.getElement(), (String[])EarChildOrder.APPLICATION, (String)"module");
        DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"connector", (String)uri);
        if (altDd != null) {
            DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"alt-dd", (String)altDd);
        }
        ConnectorModuleImpl module = new ConnectorModuleImpl(this, moduleElement);
        this.myConnectorModules.put(module.getUri(), module);
        this.added((DescriptorEntity)module);
        return module;
    }

    protected void updateEjbModule(String uri) {
        EjbModule module;
        if (this.myEjbModules != null && (module = (EjbModule)this.myEjbModules.remove(uri)) != null && module.isValid()) {
            this.myEjbModules.put(module.getUri(), module);
        }
    }

    public EjbModule[] getEjbModules() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        if (this.myEjbModules.isEmpty()) {
            return null;
        }
        Collection modules = this.myEjbModules.values();
        return modules.toArray(new EjbModule[modules.size()]);
    }

    public EjbModule getEjbModule(String uri) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        return (EjbModule)this.myEjbModules.get(uri);
    }

    public boolean canCreateEjbModule(String uri, String altDd) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readModules();
        return !DescriptorEntityImpl.isNull((String)uri) && !this.myEjbModules.containsKey(uri);
    }

    public EjbModule createEjbModule(String uri, String altDd) {
        if (!this.canCreateEjbModule(uri, altDd)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element moduleElement = DomUtils.createChildElement((Element)this.getElement(), (String[])EarChildOrder.APPLICATION, (String)"module");
        DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"ejb", (String)uri);
        if (altDd != null) {
            DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"alt-dd", (String)altDd);
        }
        EjbModuleImpl module = new EjbModuleImpl(this, moduleElement);
        this.myEjbModules.put(module.getUri(), module);
        this.added((DescriptorEntity)module);
        return module;
    }

    public EjbJar getReferencedEjbJar(EjbModule module) {
        if (!this.isRecognized()) {
            return null;
        }
        IFile file = UriResolver.getDescriptor((IFile)this.getFile(), (String)module.getUri());
        if (file == null) {
            return null;
        }
        EjbJarProject ejbJarProject = EjbJarProject.getInstance((IProject)file.getProject());
        if (ejbJarProject == null) {
            return null;
        }
        return ejbJarProject.getEjbJar(file);
    }

    public String getEjbModuleUri(EjbJar ejbJar) {
        return UriResolver.getUri((IFile)this.getFile(), (IFile)ejbJar.getFile());
    }

    protected void updateJavaModule(String uri) {
        JavaModule module;
        if (this.myJavaModules != null && (module = (JavaModule)this.myJavaModules.remove(uri)) != null && module.isValid()) {
            this.myJavaModules.put(module.getUri(), module);
        }
    }

    public JavaModule[] getJavaModules() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        if (this.myJavaModules.isEmpty()) {
            return null;
        }
        Collection modules = this.myJavaModules.values();
        return modules.toArray(new JavaModule[modules.size()]);
    }

    public JavaModule getJavaModule(String uri) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        return (JavaModule)this.myJavaModules.get(uri);
    }

    public boolean canCreateJavaModule(String uri, String altDd) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readModules();
        return !DescriptorEntityImpl.isNull((String)uri) && !this.myJavaModules.containsKey(uri);
    }

    public JavaModule createJavaModule(String uri, String altDd) {
        if (!this.canCreateJavaModule(uri, altDd)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element moduleElement = DomUtils.createChildElement((Element)this.getElement(), (String[])EarChildOrder.APPLICATION, (String)"module");
        DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"java", (String)uri);
        if (altDd != null) {
            DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"alt-dd", (String)altDd);
        }
        JavaModuleImpl module = new JavaModuleImpl(this, moduleElement);
        this.myJavaModules.put(module.getUri(), module);
        this.added((DescriptorEntity)module);
        return module;
    }

    protected void updateWebModule(String uri) {
        WebModule module;
        if (this.myWebModules != null && (module = (WebModule)this.myWebModules.remove(uri)) != null && module.isValid()) {
            this.myWebModules.put(module.getUri(), module);
        }
    }

    public WebModule[] getWebModules() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        if (this.myWebModules.isEmpty()) {
            return null;
        }
        Collection modules = this.myWebModules.values();
        return modules.toArray(new WebModule[modules.size()]);
    }

    public WebModule getWebModule(String uri) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readModules();
        return (WebModule)this.myWebModules.get(uri);
    }

    public boolean canCreateWebModule(String uri, String altDd, String contextRoot) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readModules();
        if (DescriptorEntityImpl.isNull((String)uri) || this.myWebModules.containsKey(uri)) {
            return false;
        }
        return contextRoot != null;
    }

    public WebModule createWebModule(String uri, String altDd, String contextRoot) {
        if (!this.canCreateWebModule(uri, altDd, contextRoot)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element moduleElement = DomUtils.createChildElement((Element)this.getElement(), (String[])EarChildOrder.APPLICATION, (String)"module");
        Element webElement = DomUtils.createChildElement((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"web");
        DomUtils.setChildTextNodeValue((Element)webElement, (String[])EarChildOrder.WEB, (String)"web-uri", (String)uri);
        DomUtils.setChildTextNodeValue((Element)webElement, (String[])EarChildOrder.WEB, (String)"context-root", (String)contextRoot);
        if (altDd != null) {
            DomUtils.setChildTextNodeValue((Element)moduleElement, (String[])EarChildOrder.MODULE, (String)"alt-dd", (String)altDd);
        }
        WebModuleImpl module = new WebModuleImpl(this, moduleElement);
        this.myWebModules.put(module.getUri(), module);
        this.added((DescriptorEntity)module);
        return module;
    }

    public WebApp getReferencedWebApp(WebModule module) {
        if (!this.isRecognized()) {
            return null;
        }
        IFile file = UriResolver.getDescriptor((IFile)this.getFile(), (String)module.getUri());
        if (file == null) {
            return null;
        }
        WebAppProject webAppProject = WebAppProject.getInstance((IProject)file.getProject());
        if (webAppProject == null) {
            return null;
        }
        return webAppProject.getWebApp(file);
    }

    public String getWebModuleUri(WebApp webApp) {
        return UriResolver.getUri((IFile)this.getFile(), (IFile)webApp.getFile());
    }

    protected void readModules() {
        if (this.myConnectorModules == null) {
            this.myConnectorModules = new HashMap();
            this.myEjbModules = new HashMap();
            this.myJavaModules = new HashMap();
            this.myWebModules = new HashMap();
            Element[] modules = DomUtils.getChildElements((Element)this.getElement(), (String)"module");
            int i = 0;
            while (i < modules.length) {
                String uri;
                AbstractModule module;
                if (!DescriptorEntityImpl.isNull((String)DomUtils.getChildTextNodeValue((Element)modules[i], (String)"connector"))) {
                    module = new ConnectorModuleImpl(this, modules[i]);
                    uri = module.getUri();
                    if (!DescriptorEntityImpl.isNull((String)uri) && !this.myConnectorModules.containsKey(uri)) {
                        this.myConnectorModules.put(uri, module);
                    }
                } else if (!DescriptorEntityImpl.isNull((String)DomUtils.getChildTextNodeValue((Element)modules[i], (String)"ejb"))) {
                    module = new EjbModuleImpl(this, modules[i]);
                    uri = module.getUri();
                    if (!DescriptorEntityImpl.isNull((String)uri) && !this.myEjbModules.containsKey(uri)) {
                        this.myEjbModules.put(uri, module);
                    }
                } else if (!DescriptorEntityImpl.isNull((String)DomUtils.getChildTextNodeValue((Element)modules[i], (String)"java"))) {
                    module = new JavaModuleImpl(this, modules[i]);
                    uri = module.getUri();
                    if (!DescriptorEntityImpl.isNull((String)uri) && !this.myJavaModules.containsKey(uri)) {
                        this.myJavaModules.put(uri, module);
                    }
                } else if (DomUtils.getChildElement((Element)modules[i], (String)"web") != null && !DescriptorEntityImpl.isNull((String)(uri = (module = new WebModuleImpl(this, modules[i])).getUri())) && !this.myWebModules.containsKey(uri)) {
                    this.myWebModules.put(uri, module);
                }
                ++i;
            }
        }
    }

    public void reload() {
        this.myUserInterface = null;
        this.myConnectorModules = null;
        this.myEjbModules = null;
        this.myJavaModules = null;
        this.myWebModules = null;
        this.mySecurityRoles = null;
        super.reload();
        if (this.isRecognized()) {
            this.myUserInterface = new UserInterfaceImpl((DescriptorEntityImpl)this, this.getElement(), EarChildOrder.APPLICATION, "application");
        }
    }

    protected String getPublicId() {
        return PUBLIC_ID;
    }

    protected String getSystemId() {
        return SYSTEM_ID;
    }

    protected String getDtd() {
        if (ourDtd == null) {
            ourDtd = FileUtils.getFileContents((String)DTD_PATH, (String)"", (Plugin)EarImplPlugin.getDefault());
        }
        return ourDtd;
    }
}

