/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfPab;
import java.security.cert.X509Certificate;

public class SsfSigRcpInfo {
    public static final int SSF_INITIAL = -1;
    public static final int SSF_OK = 0;
    public static final int SSF_INVALID_SIG = 1;
    public static final int SSF_NO_CERTIFICATE = 2;
    public static final int SSF_INVALID_CERT = 3;
    public static final int SSF_UNTRUSTED_CERT = 4;
    public static final int SSF_INVALID_REFERENCE = 5;
    public static final int SSF_UNKNOWN_SIGALG = 6;
    public static final int SSF_UNKNOWN_ENCRYPTALG = 7;
    public static final int SSF_UNKNOWN_HASHALG = 8;
    public static final int SSF_UNKNOWN_TRANSFORM = 9;
    public static final int SSF_UNKNOWN_CANONALG = 10;
    public X509Certificate cert;
    public int rc;

    public SsfSigRcpInfo() {
        this(null, -1);
    }

    public SsfSigRcpInfo(X509Certificate cert) {
        this(cert, -1);
    }

    public SsfSigRcpInfo(X509Certificate cert, int rc) {
        this.cert = cert;
        this.rc = rc;
    }

    public void setInitial() {
        this.rc = -1;
    }

    public boolean checkInitialCert(ISsfPab pab) {
        boolean res = false;
        if (this.rc == -1) {
            if (this.cert == null) {
                this.rc = 2;
            } else {
                try {
                    this.cert.checkValidity();
                    if (pab == null || pab.isTrusted(this.cert)) {
                        this.rc = 0;
                        res = true;
                    } else {
                        this.rc = 4;
                    }
                }
                catch (Exception e) {
                    this.rc = 3;
                }
            }
        }
        return res;
    }

    public String toString() {
        String info = "Certificate = " + this.cert;
        info = info + ", State = " + this.rc;
        return info;
    }
}

