/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.security.core.server.ssf.SsfInvalidAlgException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class SsfRefXMLInfo {
    public static final String TRANS_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANS_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANS_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANS_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TRANS_C14N_EXCL = "http://www.w3.org/2000/09/xmldsig#excludeC14N";
    public static final String TRANS_C14N_EXCL_WITHCOMMENTS = "http://www.w3.org/2000/09/xmldsig#excludeC14NwithComments";
    public static final String TRANS_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANS_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TRANS_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TRANS_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TRANS_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String DIGEST_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final int STATUS_INITIAL = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_UNREACHABLE = 1;
    public static final int STATUS_DIGEST_VALUE = 2;
    public static final int STATUS_UNKNOWN_TRANSALG = 3;
    public static final int STATUS_UNKNOWN_DIGESTALG = 4;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfRefXMLInfo == null ? (class$com$sap$security$core$server$ssf$SsfRefXMLInfo = SsfRefXMLInfo.class$("com.sap.security.core.server.ssf.SsfRefXMLInfo")) : class$com$sap$security$core$server$ssf$SsfRefXMLInfo));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    public String uri = "";
    public String[] trans = null;
    private Transformation[] transObj = null;
    public int status = -1;
    public String digest = "http://www.w3.org/2000/09/xmldsig#sha1";
    public boolean contentOnly = false;
    public String uriED = "";
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfRefXMLInfo;

    public SsfRefXMLInfo() {
    }

    public SsfRefXMLInfo(String uri) {
        this.uri = uri;
    }

    public SsfRefXMLInfo(String uri, String[] trans) {
        this.uri = uri;
        this.trans = trans;
    }

    public SsfRefXMLInfo(String uri, String[] trans, String digest) {
        this.uri = uri;
        this.trans = trans;
        this.digest = digest;
    }

    public SsfRefXMLInfo(String uri, String[] trans, String digest, boolean contentOnly) {
        this.uri = uri;
        this.trans = trans;
        this.digest = digest;
        this.contentOnly = contentOnly;
    }

    public SsfRefXMLInfo(String uri, String[] trans, String digest, boolean contentOnly, String uriED) {
        this.uri = uri;
        this.trans = trans;
        this.digest = digest;
        this.contentOnly = contentOnly;
        this.uriED = uriED;
    }

    public Transformation[] getTransformations() throws SsfInvalidAlgException {
        String me = "getTransformations()";
        loc.entering("getTransformations()");
        if (this.transObj == null) {
            int len = this.trans == null ? 0 : this.trans.length;
            this.transObj = new Transformation[len];
            int i = 0;
            while (i < len) {
                try {
                    this.transObj[i] = Transformation.getInstance((String)this.trans[i], null);
                }
                catch (SignatureException e) {
                    this.status = 3;
                    cat.warningT(loc, "Get transformation EXCEPTION " + (Object)((Object)e));
                    SsfInvalidAlgException ex = new SsfInvalidAlgException("Invalid transformation " + this.trans[i]);
                    loc.throwing("getTransformations()", (Throwable)ex);
                    throw ex;
                }
                ++i;
            }
        }
        loc.exiting((Object)this.transObj);
        return this.transObj;
    }

    public boolean setTransformations(Transformation[] transObj) {
        String me = "setTransformations(Transformation[] transObj)";
        loc.entering("setTransformations(Transformation[] transObj)", (Object[])transObj);
        boolean res = false;
        if (transObj != null) {
            this.transObj = transObj;
            int len = transObj.length;
            this.trans = new String[len];
            int i = 0;
            while (i < len) {
                this.trans[i] = transObj[i].uri;
                ++i;
            }
            res = true;
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public String toString() {
        int i;
        String info = "uri = " + this.uri;
        if (this.trans == null) {
            info = info + ", trans = null";
        } else {
            i = 0;
            while (i < this.trans.length) {
                info = info + ", trans[" + i + "] = " + this.trans[i];
                ++i;
            }
        }
        if (this.transObj == null) {
            info = info + ", transObj = null";
        } else {
            i = 0;
            while (i < this.transObj.length) {
                info = info + ", transObj[" + i + "] = " + this.transObj[i];
                ++i;
            }
        }
        info = info + ", status = " + this.status;
        info = info + ", digest = " + this.digest;
        info = info + ", contentOnly = " + this.contentOnly;
        info = info + ", uriED = " + this.uriED;
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

