/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.server.ssf.SsfProfileBasicImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.x509.ChainVerifier;
import iaik.x509.X509Certificate;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.Arrays;

public class SsfProfilePKCS12File
implements ISsfProfile {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfProfilePKCS12File == null ? (class$com$sap$security$core$server$ssf$SsfProfilePKCS12File = SsfProfilePKCS12File.class$("com.sap.security.core.server.ssf.SsfProfilePKCS12File")) : class$com$sap$security$core$server$ssf$SsfProfilePKCS12File));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private SsfProfileBasicImpl profile;
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfProfilePKCS12File;

    public SsfProfilePKCS12File(String filename, String pwd) throws FileNotFoundException, KeyStoreException, KeyManagementException {
        this(new FileInputStream(filename), pwd);
    }

    public SsfProfilePKCS12File(InputStream is, String pwd) throws KeyStoreException, KeyManagementException {
        java.security.cert.X509Certificate[] certchain;
        X509Certificate owncert;
        KeyBag keybag;
        byte[] keyID;
        CertificateBag[] certBags;
        PKCS12 p12;
        block11: {
            this.profile = null;
            String me = "SsfProfilePKCS12File(InputStream is, String pwd)";
            loc.entering("SsfProfilePKCS12File(InputStream is, String pwd)", new Object[]{is, pwd == null ? "null" : "(pwd)"});
            p12 = null;
            certBags = null;
            keyID = null;
            keybag = null;
            owncert = null;
            certchain = null;
            try {
                p12 = new PKCS12(is);
                char[] pw = pwd.toCharArray();
                if (p12.verify(pw)) {
                    p12.decrypt(pw);
                    break block11;
                }
                KeyManagementException ex = new KeyManagementException("Cannot open PKCS12 file: wrong password");
                loc.throwing("SsfProfilePKCS12File(InputStream is, String pwd)", (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                KeyStoreException ex = new KeyStoreException("Cannot read PKCS12 file: " + e);
                loc.throwing("SsfProfilePKCS12File(InputStream is, String pwd)", (Throwable)ex);
                throw ex;
            }
        }
        if (p12 == null) {
            KeyStoreException ex = new KeyStoreException("Cannot open PKCS12 file: got null pointer");
            loc.throwing("SsfProfilePKCS12File(InputStream is, String pwd)", (Throwable)ex);
            throw ex;
        }
        keybag = p12.getKeyBag();
        certBags = p12.getCertificateBags();
        if (keybag != null) {
            keyID = keybag.getLocalKeyID();
            int certLeng = 0;
            if (certBags != null) {
                certLeng = certBags.length;
            }
            int i = 0;
            while (i < certLeng) {
                if (Arrays.equals(certBags[i].getLocalKeyID(), keyID)) {
                    owncert = certBags[i].getCertificate();
                    break;
                }
                ++i;
            }
        }
        if (owncert != null) {
            try {
                certchain = ChainVerifier.orderCertificateChain(owncert, (java.security.cert.X509Certificate[])CertificateBag.getCertificates((CertificateBag[])certBags));
            }
            catch (CertificateException e) {
                cat.warningT(loc, "Order certificate chain EXCEPTION " + e);
            }
        }
        this.profile = new SsfProfileBasicImpl(keybag.getPrivateKey(), certchain);
        loc.exiting();
    }

    public PrivateKey getPrivateKey() {
        return this.profile.getPrivateKey();
    }

    public java.security.cert.X509Certificate getCertificate() {
        return this.profile.getCertificate();
    }

    public java.security.cert.X509Certificate[] getCertificateChain() {
        return this.profile.getCertificateChain();
    }

    public String toString() {
        return this.profile.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

