/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.server.ssf.SsfProfileBasicImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class SsfProfileKeyStore
implements ISsfProfile {
    private static final String cl = "com.sap.security.core.server.ssf.SsfProfileKeyStore";
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfProfileKeyStore == null ? (class$com$sap$security$core$server$ssf$SsfProfileKeyStore = SsfProfileKeyStore.class$("com.sap.security.core.server.ssf.SsfProfileKeyStore")) : class$com$sap$security$core$server$ssf$SsfProfileKeyStore));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private SsfProfileBasicImpl profile = null;
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfProfileKeyStore;

    public SsfProfileKeyStore(KeyStore keyStore, String alias, String pwd) throws KeyStoreException {
        String me = "SsfProfileKeyStore(KeyStore keyStore, String alias, String pwd)";
        loc.entering("SsfProfileKeyStore(KeyStore keyStore, String alias, String pwd)", new Object[]{keyStore, alias, pwd == null ? "null" : "(pwd)"});
        String keyAlias = null;
        keyAlias = alias == null ? this.getFirstKeyEntry(keyStore) : alias;
        PrivateKey privKey = this.getPrivateKey(keyStore, keyAlias, pwd);
        X509Certificate[] certChain = this.getCertificateChain(keyStore, keyAlias);
        this.profile = new SsfProfileBasicImpl(privKey, certChain);
        loc.exiting();
    }

    public SsfProfileKeyStore(InputStream is, String type, String kspwd, String alias, String pwd) throws KeyStoreException {
        String me = "SsfProfileKeyStore(String type, InputStream is, String kspwd, String alias, String pwd)";
        String log_kspwd = kspwd == null ? "null" : "(kspwd)";
        String log_pwd = pwd == null ? "null" : "(pwd)";
        loc.entering("SsfProfileKeyStore(String type, InputStream is, String kspwd, String alias, String pwd)", new Object[]{type, is, log_kspwd, alias, log_pwd});
        KeyStore keyStore = KeyStore.getInstance(type);
        char[] c_kspwd = null;
        if (kspwd != null) {
            c_kspwd = kspwd.toCharArray();
        }
        try {
            keyStore.load(is, c_kspwd);
        }
        catch (Exception e) {
            cat.warningT(loc, "Load key store EXCEPTION " + e);
            KeyStoreException ex = new KeyStoreException("Cannot load key store from" + is);
            loc.throwing("SsfProfileKeyStore(String type, InputStream is, String kspwd, String alias, String pwd)", (Throwable)ex);
            throw ex;
        }
        String keyAlias = null;
        keyAlias = alias == null ? this.getFirstKeyEntry(keyStore) : alias;
        PrivateKey privKey = this.getPrivateKey(keyStore, keyAlias, pwd);
        X509Certificate[] certChain = this.getCertificateChain(keyStore, keyAlias);
        this.profile = new SsfProfileBasicImpl(privKey, certChain);
        loc.exiting();
    }

    public PrivateKey getPrivateKey() {
        return this.profile.getPrivateKey();
    }

    public X509Certificate getCertificate() {
        return this.profile.getCertificate();
    }

    public X509Certificate[] getCertificateChain() {
        return this.profile.getCertificateChain();
    }

    public String toString() {
        return this.profile.toString();
    }

    private String getFirstKeyEntry(KeyStore ks) {
        String me = "getFirstKeyEntry(KeyStore ks)";
        loc.entering("getFirstKeyEntry(KeyStore ks)", new Object[]{ks});
        String entry = null;
        try {
            Enumeration<String> allEntries = ks.aliases();
            while (allEntries.hasMoreElements()) {
                String next = allEntries.nextElement();
                if (!ks.isKeyEntry(next)) continue;
                entry = next;
                break;
            }
        }
        catch (KeyStoreException e) {
            cat.warningT(loc, "Get first key entry EXCEPTION " + e);
        }
        loc.exiting(entry);
        return entry;
    }

    private PrivateKey getPrivateKey(KeyStore ks, String keyAlias, String keyPwd) {
        String me = "getPrivateKey(KeyStore ks, String keyAlias, String keyPwd)";
        loc.entering("getPrivateKey(KeyStore ks, String keyAlias, String keyPwd)", new Object[]{ks, keyAlias, keyPwd == null ? "null" : "(keyPwd)"});
        Key key = null;
        char[] pwdArray = null;
        if (keyPwd != null) {
            pwdArray = keyPwd.toCharArray();
        }
        try {
            key = ks.getKey(keyAlias, pwdArray);
        }
        catch (Exception e) {
            cat.warningT(loc, "Get key from key store EXCEPTION " + e);
        }
        PrivateKey privKey = null;
        try {
            privKey = (PrivateKey)key;
        }
        catch (ClassCastException e) {
            cat.warningT(loc, "Cast key to PrivateKey EXCEPTION " + e);
        }
        loc.exiting((Object)(privKey == null ? "null" : "(PrivateKey)"));
        return privKey;
    }

    private X509Certificate[] getCertificateChain(KeyStore ks, String keyAlias) {
        String me = "getCertificateChain(KeyStore ks, String keyAlias)";
        loc.entering("getCertificateChain(KeyStore ks, String keyAlias)", new Object[]{ks, keyAlias});
        Certificate[] certChain = null;
        try {
            certChain = ks.getCertificateChain(keyAlias);
        }
        catch (KeyStoreException e) {
            cat.warningT(loc, "Get certificate chain EXCEPTION " + e);
        }
        int len = certChain == null ? 0 : certChain.length;
        X509Certificate[] certChainX509 = new X509Certificate[len];
        int i = 0;
        while (i < len) {
            try {
                certChainX509[i] = (X509Certificate)certChain[i];
            }
            catch (ClassCastException e) {
                cat.warningT(loc, "Cast certificate to X509 EXCEPTION " + e);
            }
            ++i;
        }
        loc.exiting((Object)certChainX509);
        return certChainX509;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

