/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfPab;
import com.sap.security.core.server.ssf.SsfPabBasicImpl;
import com.sap.tc.logging.Location;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.PKCS12;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;

public class SsfPabPKCS12File
implements ISsfPab {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfPabPKCS12File == null ? (class$com$sap$security$core$server$ssf$SsfPabPKCS12File = SsfPabPKCS12File.class$("com.sap.security.core.server.ssf.SsfPabPKCS12File")) : class$com$sap$security$core$server$ssf$SsfPabPKCS12File));
    private SsfPabBasicImpl pab = null;
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfPabPKCS12File;

    public SsfPabPKCS12File(String filename, String pwd) throws FileNotFoundException, KeyStoreException, KeyManagementException {
        this(new FileInputStream(filename), pwd);
    }

    public SsfPabPKCS12File(InputStream is, String pwd) throws KeyStoreException, KeyManagementException {
        String me = "SsfPabPKCS12File(InputStream is, String pwd)";
        loc.entering("SsfPabPKCS12File(InputStream is, String pwd)", new Object[]{is, pwd == null ? "null" : "(pwd)"});
        PKCS12 p12 = null;
        try {
            p12 = new PKCS12(is);
            char[] pw = pwd.toCharArray();
            if (!p12.verify(pw)) {
                KeyManagementException ex = new KeyManagementException("Cannot open PKCS12 file: wrong password");
                loc.throwing("SsfPabPKCS12File(InputStream is, String pwd)", (Throwable)ex);
                throw ex;
            }
            p12.decrypt(pw);
        }
        catch (Exception e) {
            KeyStoreException ex = new KeyStoreException("Cannot read PKCS12 file: " + e);
            loc.throwing("SsfPabPKCS12File(InputStream is, String pwd)", (Throwable)ex);
            throw ex;
        }
        iaik.x509.X509Certificate[] certs = null;
        if (p12 == null) {
            KeyStoreException ex = new KeyStoreException("Cannot open PKCS12 file: got null pointer");
            loc.throwing("SsfPabPKCS12File(InputStream is, String pwd)", (Throwable)ex);
            throw ex;
        }
        CertificateBag[] certBags = p12.getCertificateBags();
        if (certBags != null) {
            certs = CertificateBag.getCertificates((CertificateBag[])certBags);
        }
        this.pab = new SsfPabBasicImpl((X509Certificate[])certs);
        loc.exiting();
    }

    public boolean addUntrustedCertificate(X509Certificate cert) {
        return this.pab.addUntrustedCertificate(cert);
    }

    public X509Certificate[] getCertificates() {
        return this.pab.getCertificates();
    }

    public X509Certificate getCertificateBySubjectDN(String subjectdn) {
        return this.pab.getCertificateBySubjectDN(subjectdn);
    }

    public boolean isTrusted(X509Certificate cert) {
        return this.pab.isTrusted(cert);
    }

    public String toString() {
        return this.pab.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

