/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfPab;
import com.sap.security.core.server.ssf.SsfPabBasicImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class SsfPabKeyStore
implements ISsfPab {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfPabKeyStore == null ? (class$com$sap$security$core$server$ssf$SsfPabKeyStore = SsfPabKeyStore.class$("com.sap.security.core.server.ssf.SsfPabKeyStore")) : class$com$sap$security$core$server$ssf$SsfPabKeyStore));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private SsfPabBasicImpl pab = null;
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfPabKeyStore;

    public SsfPabKeyStore(KeyStore keyStore) throws KeyStoreException {
        String me = "SsfPabKeyStore(KeyStore keyStore)";
        loc.entering("SsfPabKeyStore(KeyStore keyStore)", new Object[]{keyStore});
        ArrayList certList = this.getCertList(keyStore);
        int size = certList.size();
        X509Certificate[] certArray = new X509Certificate[size];
        int i = 0;
        while (i < size) {
            certArray[i] = (X509Certificate)certList.get(i);
            ++i;
        }
        this.pab = new SsfPabBasicImpl(certArray);
        loc.exiting();
    }

    public SsfPabKeyStore(InputStream is, String type, String kspwd) throws KeyStoreException {
        String me = "SsfPabKeyStore(InputStream is, String type, String kspwd)";
        loc.entering("SsfPabKeyStore(InputStream is, String type, String kspwd)", new Object[]{is, type, kspwd == null ? "null" : "(kspwd)"});
        KeyStore keyStore = KeyStore.getInstance(type);
        char[] c_kspwd = null;
        if (kspwd != null) {
            c_kspwd = kspwd.toCharArray();
        }
        try {
            keyStore.load(is, c_kspwd);
        }
        catch (Exception e) {
            cat.warningT(loc, "Load key store EXCEPTION " + e);
            KeyStoreException ex = new KeyStoreException("Cannot load key store from" + is);
            loc.throwing("SsfPabKeyStore(InputStream is, String type, String kspwd)", (Throwable)ex);
            throw ex;
        }
        ArrayList certs = this.getCertList(keyStore);
        this.pab = new SsfPabBasicImpl((X509Certificate[])certs.toArray());
        loc.exiting();
    }

    private ArrayList getCertList(KeyStore ks) throws KeyStoreException {
        String me = "getCertList()";
        loc.entering("getCertList()");
        ArrayList<iaik.x509.X509Certificate> certList = new ArrayList<iaik.x509.X509Certificate>();
        Enumeration<String> allEntries = ks.aliases();
        while (allEntries.hasMoreElements()) {
            String entry = allEntries.nextElement();
            if (!ks.isCertificateEntry(entry)) continue;
            Certificate cert = ks.getCertificate(entry);
            try {
                iaik.x509.X509Certificate x509cert = new iaik.x509.X509Certificate(cert.getEncoded());
                certList.add(x509cert);
            }
            catch (Exception e) {
                cat.warningT(loc, "Add certificate EXCEPTION " + e);
            }
        }
        loc.exiting(certList);
        return certList;
    }

    public boolean addUntrustedCertificate(X509Certificate cert) {
        return this.pab.addUntrustedCertificate(cert);
    }

    public X509Certificate[] getCertificates() {
        return this.pab.getCertificates();
    }

    public X509Certificate getCertificateBySubjectDN(String subjectdn) {
        return this.pab.getCertificateBySubjectDN(subjectdn);
    }

    public boolean isTrusted(X509Certificate cert) {
        return this.pab.isTrusted(cert);
    }

    public String toString() {
        return this.pab.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

