/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfPab;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.x509.ChainVerifier;
import iaik.x509.SimpleChainVerifier;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class SsfPabBasicImpl
implements ISsfPab {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfPabBasicImpl == null ? (class$com$sap$security$core$server$ssf$SsfPabBasicImpl = SsfPabBasicImpl.class$("com.sap.security.core.server.ssf.SsfPabBasicImpl")) : class$com$sap$security$core$server$ssf$SsfPabBasicImpl));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private X509Certificate[] trustedCerts = null;
    private SimpleChainVerifier chainVerifier = new SimpleChainVerifier();
    private ArrayList allCerts = new ArrayList();
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfPabBasicImpl;

    public SsfPabBasicImpl(X509Certificate[] trustedCerts) {
        String me = "SsfPabBasicImpl(X509Certificate[] trustedCerts)";
        loc.entering("SsfPabBasicImpl(X509Certificate[] trustedCerts)", new Object[]{trustedCerts});
        this.trustedCerts = trustedCerts == null ? new X509Certificate[0] : trustedCerts;
        this.chainVerifier.setTrustedCertificates(this.trustedCerts);
        int i = 0;
        while (i < this.trustedCerts.length) {
            this.addUntrustedCertificate(this.trustedCerts[i]);
            ++i;
        }
        loc.exiting();
    }

    public boolean addUntrustedCertificate(X509Certificate cert) {
        return this.allCerts.add(cert);
    }

    public X509Certificate[] getCertificates() {
        String me = "getCertificates()";
        loc.entering("getCertificates()");
        loc.exiting((Object)this.trustedCerts);
        return this.trustedCerts;
    }

    public X509Certificate getCertificateBySubjectDN(String subjectdn) {
        String me = "getCertificateBySubjectDN(String)";
        loc.entering("getCertificateBySubjectDN(String)", new Object[]{subjectdn});
        X509Certificate cert = null;
        int i = 0;
        while (i < this.trustedCerts.length) {
            if (this.trustedCerts[i].getSubjectDN().getName().equals(subjectdn)) {
                cert = this.trustedCerts[i];
                break;
            }
            ++i;
        }
        loc.exiting(cert);
        return cert;
    }

    public boolean isTrusted(X509Certificate cert) {
        String me = "isTrusted(X509Certificate)";
        loc.entering("isTrusted(X509Certificate)", new Object[]{cert});
        if (this.chainVerifier == null) {
            cat.errorT(loc, "Get chainVerifierfier FAILED - null");
            loc.exiting();
            return false;
        }
        if (cert == null) {
            cat.errorT(loc, "Check certificate FAILED - null");
            loc.exiting();
            return false;
        }
        boolean res = false;
        try {
            X509Certificate[] certStock = new X509Certificate[this.allCerts.size()];
            certStock = this.allCerts.toArray(certStock);
            X509Certificate[] certChain = ChainVerifier.orderCertificateChain((X509Certificate)cert, (X509Certificate[])certStock);
            res = this.chainVerifier.verifyChain(certChain);
        }
        catch (CertificateException e) {
            cat.errorT(loc, "Is trusted certificate EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public String toString() {
        String info = "Trusted certificates = { \n";
        int i = 0;
        while (i < this.trustedCerts.length) {
            info = info + this.trustedCerts[i].getSubjectDN().getName() + " \n";
            ++i;
        }
        info = info + "}";
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

