/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKeyGenerator;
import com.sap.engine.lib.xml.signature.encryption.XMLDecryptor;
import com.sap.engine.lib.xml.signature.encryption.XMLEncryptor;
import com.sap.engine.lib.xml.signature.generator.KeyInfoGenerator;
import com.sap.engine.lib.xml.signature.generator.SignatureGenerator;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.verifier.SignatureVerifier;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.security.api.ssf.ISsfData;
import com.sap.security.api.ssf.ISsfPab;
import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.server.ssf.SsfInvalidAlgException;
import com.sap.security.core.server.ssf.SsfInvalidDataException;
import com.sap.security.core.server.ssf.SsfInvalidKeyException;
import com.sap.security.core.server.ssf.SsfRefXMLInfo;
import com.sap.security.core.server.ssf.SsfRefXMLList;
import com.sap.security.core.server.ssf.SsfSigRcpInfo;
import com.sap.security.core.server.ssf.SsfSigRcpList;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SsfDataXML
implements ISsfData {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfDataXML == null ? (class$com$sap$security$core$server$ssf$SsfDataXML = SsfDataXML.class$("com.sap.security.core.server.ssf.SsfDataXML")) : class$com$sap$security$core$server$ssf$SsfDataXML));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private Element data = null;
    private String canonAlgURI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String encryptionSpecNS = "http://www.w3.org/2001/04/xmlenc#";
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfDataXML;

    public SsfDataXML(InputStream in) throws IOException, SsfInvalidDataException {
        String me = "SsfDataXML(InputStream in)";
        loc.entering("SsfDataXML(InputStream in)", new Object[]{in});
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
        BufferedInputStream bis = new BufferedInputStream(in);
        try {
            DOMParser parser = new DOMParser();
            this.data = parser.parse((InputStream)bis).getDocumentElement();
        }
        catch (Exception e) {
            cat.warningT(loc, "Load XML document EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("No XML data provided");
            loc.throwing("SsfDataXML(InputStream in)", (Throwable)ex);
            throw ex;
        }
        loc.exiting();
    }

    public SsfDataXML(Element el) throws SsfInvalidDataException {
        String me = "SsfDataXML(Element el)";
        loc.entering("SsfDataXML(Element el)", new Object[]{el});
        if (el == null) {
            cat.warningT(loc, "No XML data provided: null reference");
            SsfInvalidDataException ex = new SsfInvalidDataException("No XML data provided");
            loc.throwing("SsfDataXML(Element el)", (Throwable)ex);
            throw ex;
        }
        this.data = el;
        loc.exiting();
    }

    public boolean sign(ISsfProfile profile) throws SsfInvalidKeyException {
        String me = "sign(ISsfProfile profile)";
        loc.entering("sign(ISsfProfile profile)", new Object[]{profile});
        boolean res = false;
        try {
            res = this.sign(profile, "SHA", 2, false);
        }
        catch (SsfInvalidAlgException e) {
            loc.errorT("Set SHA algorithm EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)";
        loc.entering("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", new Object[]{profile, mdAlg, new Integer(incCerts), new Boolean(detached)});
        String digest = null;
        if (mdAlg.equals("SHA")) {
            digest = "http://www.w3.org/2000/09/xmldsig#sha1";
        } else if (mdAlg.equals("MD5")) {
            digest = "http://www.w3.org/2001/04/xmldsig-more#md5";
        } else {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown message digest algorithm " + mdAlg);
            loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
            throw ex;
        }
        String uri = "";
        String[] trans = new String[]{"http://www.w3.org/2000/09/xmldsig#enveloped-signature", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315"};
        SsfRefXMLInfo refInfo = new SsfRefXMLInfo(uri, trans, digest);
        SsfRefXMLList refList = new SsfRefXMLList();
        if (!refList.add(refInfo)) {
            cat.errorT(loc, "Insert references FAILED");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        boolean res = this.sign(null, refList, profile, incCerts, detached, true);
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean sign(SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean detached) throws SsfInvalidKeyException, SsfInvalidAlgException {
        return this.sign(null, refList, profile, incCerts, detached, true);
    }

    public boolean sign(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean detached) throws SsfInvalidKeyException, SsfInvalidAlgException {
        return this.sign(sigHome, refList, profile, incCerts, detached, true);
    }

    public boolean sign(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean detached, boolean incKeyName) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "sign(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean detached, boolean incKeyName)";
        loc.entering("sign(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean detached, boolean incKeyName)", new Object[]{sigHome, refList, profile, new Integer(incCerts), new Boolean(detached), new Boolean(incKeyName)});
        if (sigHome == null) {
            sigHome = this.data.getOwnerDocument().createElement("dummy");
            this.data.appendChild(sigHome);
        }
        boolean res = SsfDataXML.signData(sigHome, refList, profile, incCerts, incKeyName, this.canonAlgURI);
        if (detached) {
            this.data = (Element)sigHome.getLastChild();
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public static boolean signData(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean incKeyName, String canonAlgURI) throws SsfInvalidKeyException, SsfInvalidAlgException {
        X509Certificate[] certs;
        String me = "signData(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean incKeyName)";
        loc.entering("signData(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean incKeyName)", new Object[]{sigHome, refList, profile, new Integer(incCerts), new Boolean(incKeyName)});
        SignatureGenerator generator = new SignatureGenerator();
        PrivateKey signerKey = profile.getPrivateKey();
        X509Certificate signerCert = profile.getCertificate();
        if (signerKey == null) {
            SsfInvalidKeyException ex = new SsfInvalidKeyException("Private key of signer not available");
            loc.throwing("signData(Element sigHome, SsfRefXMLList refList, ISsfProfile profile, int incCerts, boolean incKeyName)", (Throwable)ex);
            throw ex;
        }
        if (signerKey instanceof RSAPrivateKey) {
            generator.setSignatureAlgorithmURI("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
        generator.setPrivateKey(signerKey);
        if (incKeyName && signerCert != null) {
            generator.setKeyName(signerCert.getSubjectDN().getName());
        }
        int certsLen = (certs = profile.getCertificateChain()) == null ? 0 : certs.length;
        switch (incCerts) {
            case 0: {
                certsLen = 0;
                break;
            }
            case 1: {
                if (certsLen <= 0) break;
                certsLen = 1;
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (certsLen <= 1) break;
                --certsLen;
            }
        }
        Certificate[] certsInc = new X509Certificate[certsLen];
        if (certs != null) {
            System.arraycopy(certs, 0, certsInc, 0, certsLen);
        }
        generator.setCertificates(certsInc);
        generator.showKeyValue(false);
        generator.setIDAttribute(refList.getIdLocalName(), refList.getIdURI());
        int i = 0;
        while (i < refList.size()) {
            SsfRefXMLInfo refInfo = refList.get(i);
            refInfo.status = -1;
            Transformation[] trans = refInfo.getTransformations();
            try {
                generator.addReference(refInfo.uri, trans, refInfo.digest);
            }
            catch (SignatureException e) {
                cat.warningT(loc, "Add reference EXCEPTION " + (Object)((Object)e));
                loc.exiting((Object)new Boolean(false));
                return false;
            }
            refInfo.status = 0;
            ++i;
        }
        generator.setCanonicalizationAlgorithm(canonAlgURI);
        boolean res = false;
        try {
            generator.generateHere(sigHome);
            res = true;
        }
        catch (SignatureException e) {
            cat.warningT(loc, "Generate signature EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList sigList) ";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList sigList) ", new Object[]{pab, sigList});
        boolean res = this.verify(pab, sigList, null, null);
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", new Object[]{pab, sigList, input, cert});
        if (input != null) {
            if (input instanceof SsfDataXML) {
                SsfDataXML inputXML = (SsfDataXML)input;
                boolean res = inputXML.appendChild(this.data);
                if (res) {
                    res = this.verify(inputXML.getLastChild(), pab, sigList, null, cert);
                } else {
                    cat.warningT(loc, "Append signature element FAILED");
                }
                if (res) {
                    this.data = inputXML.getDataXML();
                }
                loc.exiting((Object)new Boolean(res));
                return res;
            }
            SsfInvalidDataException ex = new SsfInvalidDataException("Wrong input data provided");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        NodeList signedDataList = this.data.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int sizeList = signedDataList.getLength();
        if (sizeList == 0) {
            SsfInvalidDataException ex = new SsfInvalidDataException("No XML signature provided");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        Element envelopedSig = (Element)signedDataList.item(sizeList - 1);
        boolean res = this.verify(envelopedSig, pab, sigList, null, cert);
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert) throws SsfInvalidDataException {
        String me = "verify(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert)";
        loc.entering("verify(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert)", new Object[]{sigHome, pab, sigList, refList, cert});
        boolean res = SsfDataXML.verifyData(sigHome, pab, sigList, refList, cert);
        if (res) {
            sigHome.getParentNode().removeChild(sigHome);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public static boolean verifyData(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert) throws SsfInvalidDataException {
        String me = "verifyData(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert)";
        loc.entering("verifyData(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert)", new Object[]{sigHome, pab, sigList, refList, cert});
        SignatureVerifier verifier = null;
        try {
            verifier = new SignatureVerifier(sigHome);
        }
        catch (SignatureException e) {
            cat.warningT(loc, "Create verifier object EXCEPTION " + (Object)((Object)e));
            SsfInvalidDataException ex = new SsfInvalidDataException("No XML signature provided");
            loc.throwing("verifyData(Element sigHome, ISsfPab pab, SsfSigRcpList sigList, SsfRefXMLList refList, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        if (refList != null) {
            verifier.setIDAttribute(refList.getIdLocalName(), refList.getIdURI());
            TransformationFactory transFact = refList.getTransformationFactory();
            if (transFact != null) {
                verifier.setTransformationFactory(transFact);
            }
            refList.clear();
        }
        if (sigList != null) {
            sigList.clear();
        }
        if (cert != null) {
            verifier.setCertificate((Certificate)cert);
        }
        boolean sigRes = false;
        try {
            sigRes = verifier.verify();
        }
        catch (SignatureException e) {
            loc.infoT("Verify signature EXCEPTION " + (Object)((Object)e));
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        boolean res = false;
        if (sigList == null) {
            sigList = new SsfSigRcpList();
        } else {
            sigList.clear();
        }
        SsfSigRcpInfo sigInfo = new SsfSigRcpInfo();
        if (sigRes) {
            Certificate sigCert = null;
            try {
                sigCert = verifier.getCertificate();
            }
            catch (Exception e) {
                cat.warningT(loc, "Get certificate EXCEPTION " + e);
            }
            if (sigCert instanceof X509Certificate) {
                sigInfo.cert = (X509Certificate)sigCert;
            }
            if (sigInfo.cert == null) {
                sigInfo.rc = 2;
                cat.warningT(loc, "Get certificate FAILED - not X509");
            }
        } else {
            int reason = verifier.getSignatureValidationResult();
            switch (reason) {
                case 1: {
                    sigInfo.rc = 2;
                    break;
                }
                case 2: {
                    sigInfo.rc = 1;
                    break;
                }
                case 3: {
                    sigInfo.rc = 5;
                    break;
                }
                case 4: {
                    sigInfo.rc = 6;
                    break;
                }
                case 5: {
                    sigInfo.rc = 10;
                    break;
                }
                default: {
                    sigInfo.rc = 1;
                }
            }
        }
        sigList.add(sigInfo);
        if (pab != null) {
            Certificate[] certInc = null;
            try {
                certInc = verifier.getCertificates();
            }
            catch (Exception e) {
                cat.warningT(loc, "Get certificates from signed data EXCEPTION " + e);
            }
            int len = certInc == null ? 0 : certInc.length;
            int i = 0;
            while (i < len) {
                if (certInc[i] instanceof X509Certificate) {
                    pab.addUntrustedCertificate((X509Certificate)certInc[i]);
                }
                ++i;
            }
        }
        res = sigList.checkInitialCerts(pab, false);
        if (refList != null) {
            Reference[] ref = verifier.getReferenceValidationResults();
            int i = 0;
            while (i < ref.length) {
                SsfRefXMLInfo refInfo = new SsfRefXMLInfo();
                refInfo.uri = ref[i].getURI();
                Transformation[] transObj = ref[i].getTransformations();
                refInfo.setTransformations(transObj);
                refInfo.digest = ref[i].getDigestAlgorithmURI();
                refInfo.status = ref[i].state;
                refList.add(refInfo);
                ++i;
            }
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(SsfSigRcpList rcpList, ISsfPab pab) throws SsfInvalidKeyException {
        String me = "encrypt(SsfSigRcpList rcpList, ISsfPab pab)";
        loc.entering("encrypt(SsfSigRcpList rcpList, ISsfPab pab)", new Object[]{rcpList, pab});
        boolean res = false;
        try {
            res = this.encrypt(rcpList, pab, "AES128_CBC");
        }
        catch (SsfInvalidAlgException e) {
            loc.errorT("Set AES128_CBC encryption EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)";
        loc.entering("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", new Object[]{rcpList, pab, symAlg});
        String symAlgURI = null;
        if ("AES128_CBC".equals(symAlg)) {
            symAlgURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        } else if ("DES_EDE3_CBC".equals(symAlg)) {
            symAlgURI = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        } else {
            throw new SsfInvalidAlgException("Unknown symmetic encryption algorithm " + symAlg);
        }
        SsfRefXMLInfo refInfo = new SsfRefXMLInfo();
        SsfRefXMLList refList = new SsfRefXMLList();
        boolean res = false;
        if (refList.add(refInfo)) {
            res = this.encrypt(null, refList, rcpList, pab, symAlgURI);
        } else {
            cat.warningT(loc, "Insert references FAILED");
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(Element keyParent, SsfRefXMLList refList, SsfSigRcpList rcpList, ISsfPab pab, String symAlgURI) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "encrypt(Element keyParent, SsfRefXMLList refList, SsfSigRcpList rcpList, ISsfPab pab, String symAlgURI, Element keyParent)";
        loc.entering("encrypt(Element keyParent, SsfRefXMLList refList, SsfSigRcpList rcpList, ISsfPab pab, String symAlgURI, Element keyParent)", new Object[]{keyParent, refList, rcpList, pab, symAlgURI});
        Document doc = this.data.getOwnerDocument();
        Element parent = null;
        Node parentNode = this.data.getParentNode();
        if (parentNode instanceof Element) {
            parent = (Element)parentNode;
        }
        String keyAlg = null;
        if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symAlgURI)) {
            keyAlg = "AES";
        } else if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symAlgURI)) {
            keyAlg = "DESede";
        } else {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown symmetric encryption algorithm URI " + symAlgURI);
            loc.throwing("encrypt(Element keyParent, SsfRefXMLList refList, SsfSigRcpList rcpList, ISsfPab pab, String symAlgURI, Element keyParent)", (Throwable)ex);
            throw ex;
        }
        KeyGenerator keyGen = null;
        try {
            keyGen = KeyGenerator.getInstance(keyAlg);
        }
        catch (NoSuchAlgorithmException e) {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown symmetric encryption algorithm URI " + symAlgURI);
            loc.throwing("encrypt(Element keyParent, SsfRefXMLList refList, SsfSigRcpList rcpList, ISsfPab pab, String symAlgURI, Element keyParent)", (Throwable)ex);
            throw ex;
        }
        SecretKey key = keyGen.generateKey();
        if (rcpList == null || rcpList.size() == 0) {
            cat.warningT(loc, "Empty recipient list, cannot perform encryption");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        rcpList.setInitial();
        if (!rcpList.checkInitialCerts(pab, true)) {
            cat.warningT(loc, "Recipient list contains untrusted certificates");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        boolean addDataRefList = false;
        Element encHome = null;
        int i = 0;
        while (i < refList.size()) {
            String id;
            String uri = refList.get((int)i).uri;
            if (uri == null || uri.equals("")) {
                encHome = this.data;
            } else {
                addDataRefList = true;
                encHome = DOM.getElementByAttribute((Node)this.data.getOwnerDocument(), (String)refList.idLocalName, (String)refList.idURI, (String)uri.substring(1));
            }
            String uriED = refList.get((int)i).uriED;
            if (addDataRefList && "".equals(uriED)) {
                refList.get((int)i).uriED = uriED = "#" + this.generateNewId(this.data.getOwnerDocument(), "Id", encryptionSpecNS, "ED");
            }
            if ((encHome = SsfDataXML.encryptData(encHome, refList.get((int)i).contentOnly, key, symAlgURI, id = uriED.startsWith("#") ? uriED.substring(1) : null)) == null) {
                loc.exiting((Object)new Boolean(false));
                return false;
            }
            ++i;
        }
        if (parent == null) {
            this.data = doc.getDocumentElement();
        }
        boolean res = true;
        try {
            KeyInfoGenerator kig = new KeyInfoGenerator();
            kig.init((Node)encHome);
            int i2 = 0;
            while (i2 < rcpList.size()) {
                X509Certificate rcpCert = rcpList.get((int)i2).cert;
                String asymAlgName = rcpCert.getPublicKey().getAlgorithm();
                if (!asymAlgName.equals("RSA")) {
                    rcpList.get((int)i2).rc = 7;
                    SsfInvalidKeyException ex = new SsfInvalidKeyException("Invalid public key algorithm " + asymAlgName);
                    loc.throwing("encrypt(Element keyParent, SsfRefXMLList refList, SsfSigRcpList rcpList, ISsfPab pab, String symAlgURI, Element keyParent)", (Throwable)ex);
                    throw ex;
                }
                String id = null;
                if (keyParent == null) {
                    keyParent = (Element)kig.getKeyInfo().getDomRepresentation();
                } else {
                    id = this.generateNewId(this.data.getOwnerDocument(), "Id", encryptionSpecNS, "EK");
                    kig.setRetrievalMethod("#" + id, "http://www.w3.org/2001/04/xmlenc#EncryptedKey", new Transformation[0]);
                }
                SsfRefXMLList dataRefList = null;
                if (addDataRefList) {
                    dataRefList = refList;
                }
                res &= SsfDataXML.encryptKey(keyParent, key, rcpCert, id, dataRefList);
                ++i2;
            }
        }
        catch (SignatureException e) {
            cat.warningT(loc, "Add encrypted key EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public static boolean encryptKey(Element keyParent, Key key, X509Certificate cert, String id, SsfRefXMLList refList) {
        String me = "encryptKey(Element keyParent, Key key, X509Certificate cert, String id, SsfRefXMLList refList)";
        loc.entering("encryptKey(Element keyParent, Key key, X509Certificate cert, String id, SsfRefXMLList refList)", new Object[]{keyParent, key, cert, id, refList});
        boolean res = false;
        try {
            EncryptedKeyGenerator ekg = new EncryptedKeyGenerator();
            ekg.init((Node)keyParent);
            ekg.setType(null);
            EncryptedKey ek = ekg.getEncryptedKey("http://www.w3.org/2001/04/xmlenc#rsa-1_5", (Key)cert.getPublicKey(), key);
            if (id != null) {
                ek.setAttribute("Id", id);
            }
            KeyInfoGenerator kig = new KeyInfoGenerator();
            kig.init(ek.getDomRepresentation());
            kig.setKeyName(cert.getSubjectDN().getName());
            if (refList != null) {
                ekg.startNewReferenceList();
                int j = 0;
                while (j < refList.size()) {
                    Transformation[] trans = refList.get(j).getTransformations();
                    ekg.addReference(trans, refList.get((int)j).uriED, true);
                    ++j;
                }
            }
            res = true;
        }
        catch (Exception e) {
            loc.infoT("Create encrypted key EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public static Element encryptData(Element encHome, boolean contentOnly, Key symKey, String symAlgURI, String id) {
        String me = "encryptData(Element encHome, boolean contentOnly, Key symKey, String id)";
        loc.entering("encryptData(Element encHome, boolean contentOnly, Key symKey, String id)", new Object[]{encHome, new Boolean(contentOnly), symKey == null ? "null" : "symKey", id});
        Element encData = null;
        try {
            XMLEncryptor enc = new XMLEncryptor();
            enc.setKey(symKey);
            encData = (Element)enc.encrypt(encHome, symAlgURI, contentOnly);
            if (id != null) {
                encData.setAttribute("Id", id);
            }
        }
        catch (SignatureException e) {
            loc.infoT("Create encrypted data EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)encData);
        return encData;
    }

    public boolean decrypt(ISsfProfile profile) throws SsfInvalidKeyException, SsfInvalidDataException {
        String me = "decrypt(ISsfProfile profile)";
        loc.entering("decrypt(ISsfProfile profile)", new Object[]{profile});
        Document doc = this.data.getOwnerDocument();
        Element parent = null;
        Node parentNode = this.data.getParentNode();
        if (parentNode instanceof Element) {
            parent = (Element)parentNode;
        }
        Element encData = null;
        NodeList edList = null;
        edList = parent == null ? doc.getElementsByTagNameNS(encryptionSpecNS, "EncryptedData") : parent.getElementsByTagNameNS(encryptionSpecNS, "EncryptedData");
        if (edList == null || edList.getLength() == 0) {
            SsfInvalidDataException ex = new SsfInvalidDataException("XML does not contain encrypted data");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        encData = (Element)edList.item(0);
        boolean res = false;
        try {
            res = this.decrypt(encData, profile, null);
        }
        catch (SsfInvalidAlgException e) {
            SsfInvalidDataException ex = new SsfInvalidDataException("Decrypt secret key EXCEPTION " + e);
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean decrypt(Element encData, ISsfProfile profile, Key key) throws SsfInvalidAlgException, SsfInvalidKeyException, SsfInvalidDataException {
        String me = "decrypt(Element encData, ISsfProfile profile, Key key)";
        loc.entering("decrypt(Element encData, ISsfProfile profile, Key key)", new Object[]{encData, profile, key});
        Document doc = this.data.getOwnerDocument();
        Element parent = null;
        Node parentNode = this.data.getParentNode();
        if (parentNode instanceof Element) {
            parent = (Element)parentNode;
        }
        String symAlgURI = null;
        NodeList emList = encData.getElementsByTagNameNS(encryptionSpecNS, "EncryptionMethod");
        if (emList == null || emList.getLength() == 0) {
            cat.warningT(loc, "Could not find symmetric encryption algorithm, try AES");
            symAlgURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        } else {
            symAlgURI = emList.item(0).getAttributes().getNamedItem("Algorithm").getNodeValue();
        }
        Element[] encKey = new Element[]{null};
        if (key == null) {
            key = this.searchKey(encData, profile, symAlgURI, encKey);
        }
        if (key == null) {
            cat.warningT(loc, "Could not get symmetric key for decryption");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        boolean res = SsfDataXML.decryptData(encData, key, symAlgURI);
        if (res) {
            if (encKey[0] != null) {
                encKey[0].getParentNode().removeChild(encKey[0]);
            }
            if (parent == null) {
                this.data = doc.getDocumentElement();
            }
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public static Key decryptKey(Element encKey, ISsfProfile prof, String symAlgURI, ArrayList dataRefList) throws SsfInvalidAlgException {
        Element refListEl;
        NodeList drList;
        NodeList rlList;
        String me = "decryptKey(Element encKey, ISsfProfile prof, String symAlgURI, ArrayList dataRefList)";
        loc.entering("decryptKey(Element encKey, ISsfProfile prof, String symAlgURI, ArrayList dataRefList)", new Object[]{encKey, prof, symAlgURI, dataRefList});
        Key key = null;
        String keyAlg = null;
        if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symAlgURI)) {
            keyAlg = "AES";
        } else if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symAlgURI)) {
            keyAlg = "DESede";
        } else {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown symmetic encryption algorithm URI " + symAlgURI);
            loc.throwing("decryptKey(Element encKey, ISsfProfile prof, String symAlgURI, ArrayList dataRefList)", (Throwable)ex);
            throw ex;
        }
        EncryptedKeyGenerator ekg = new EncryptedKeyGenerator();
        try {
            EncryptedKey ek = new EncryptedKey(encKey, false);
            key = ekg.extractKey(ek, (Key)prof.getPrivateKey(), keyAlg);
        }
        catch (SignatureException e) {
            loc.infoT("Get encrypted key EXCEPTION " + (Object)((Object)e));
        }
        if (dataRefList != null && (rlList = encKey.getElementsByTagNameNS(encryptionSpecNS, "ReferenceList")) != null && rlList.getLength() == 1 && (drList = (refListEl = (Element)rlList.item(0)).getElementsByTagNameNS(encryptionSpecNS, "DataReference")) != null && drList.getLength() > 0) {
            int i = 0;
            while (i < drList.getLength()) {
                String uri = drList.item(i).getAttributes().getNamedItem("URI").getNodeValue();
                dataRefList.add(uri);
                ++i;
            }
        }
        loc.exiting((Object)(key == null ? "null" : "key"));
        return key;
    }

    public static boolean decryptData(Element encData, Key symKey, String symAlgURI) {
        String me = "decryptKey(Element encData, Key symKey, String symAlgURI) ";
        loc.entering("decryptKey(Element encData, Key symKey, String symAlgURI) ", new Object[]{encData, symKey == null ? "null" : "symKey", symAlgURI});
        boolean res = false;
        XMLDecryptor dec = new XMLDecryptor();
        dec.setKey(symKey);
        try {
            dec.restoreOriginalContent(encData, symAlgURI);
            res = true;
        }
        catch (SignatureException e) {
            loc.infoT("Perform decryption of data EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean writeTo(OutputStream out) throws IOException {
        String me = "writeTo(OutputStream out)";
        loc.entering("writeTo(OutputStream out)", new Object[]{out});
        DOMSerializer serializer = new DOMSerializer();
        serializer.setOutputProperty("indent", "no");
        try {
            serializer.write((Node)this.data, out);
        }
        catch (Exception e) {
            IOException ex = new IOException("Exception while writing XML data: " + e);
            loc.throwing("writeTo(OutputStream out)", (Throwable)ex);
            throw ex;
        }
        loc.exiting();
        return true;
    }

    public Element getDataXML() {
        String me = "getDataXML()";
        loc.entering("getDataXML()");
        loc.exiting((Object)this.data);
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean setCanonicalizationAlgorithm(String canonAlgURI) {
        String me = "setCanonicalizationAlgorithm(String canonAlgURI)";
        loc.entering("setCanonicalizationAlgorithm(String canonAlgURI)", new Object[]{canonAlgURI});
        this.canonAlgURI = canonAlgURI;
        boolean res = true;
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public String getCanonicalizationAlgorithm() {
        String me = "getCanonicalizationAlgorithm()";
        loc.entering("getCanonicalizationAlgorithm()");
        loc.exiting((Object)new Object[]{this.canonAlgURI});
        return this.canonAlgURI;
    }

    private boolean appendChild(Element el) {
        String me = "appendChild(Element el)";
        loc.entering("appendChild(Element el)", new Object[]{el});
        boolean res = false;
        try {
            this.data.appendChild(this.data.getOwnerDocument().importNode(el, true));
            res = true;
        }
        catch (DOMException e) {
            cat.warningT(loc, "Append child EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    private Element getLastChild() {
        String me = "getLastChild()";
        loc.entering("getLastChild()");
        Element el = (Element)this.data.getLastChild();
        loc.exiting((Object)el);
        return el;
    }

    private String generateNewId(Document doc, String idName, String idNS, String prefix) {
        String me = "generateNewID(Document doc, String idName, String idNS, String prefix) ";
        loc.entering("generateNewID(Document doc, String idName, String idNS, String prefix) ", new Object[]{doc, idName, idNS, prefix});
        if (prefix == null) {
            prefix = "";
        }
        String id = null;
        boolean cont = true;
        while (cont) {
            id = prefix + (int)(Math.random() * 9.9999999E7);
            if (DOM.getElementByAttribute((Node)doc, (String)idName, (String)idNS, (String)id) != null) continue;
            cont = false;
        }
        loc.exiting(id);
        return id;
    }

    private Key searchKey(Element encData, ISsfProfile profile, String symAlgURI, Element[] ekOut) throws SsfInvalidAlgException {
        String me = "lookupKey(Element encData, ISsfProfile profile, String symAlgURI)";
        loc.entering("lookupKey(Element encData, ISsfProfile profile, String symAlgURI)", new Object[]{encData, profile == null ? "null" : "profile", symAlgURI});
        try {
            NodeList kiList = encData.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
            if (kiList != null && kiList.getLength() > 0) {
                NodeList rmList;
                Element keyInfo = (Element)kiList.item(0);
                NodeList ekList = keyInfo.getElementsByTagNameNS(encryptionSpecNS, "EncryptedKey");
                if (ekList != null) {
                    int i = 0;
                    while (i < ekList.getLength()) {
                        Element ek = (Element)ekList.item(i);
                        Key key = SsfDataXML.decryptKey(ek, profile, symAlgURI, null);
                        if (key != null) {
                            ekOut[0] = ek;
                            loc.exiting((Object)"key");
                            return key;
                        }
                        ++i;
                    }
                }
                if ((rmList = keyInfo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod")) != null) {
                    int i = 0;
                    while (i < rmList.getLength()) {
                        NamedNodeMap rmAttr = rmList.item(i).getAttributes();
                        String type = rmAttr.getNamedItem("type").getNodeValue();
                        if ("http://www.w3.org/2001/04/xmlenc#EncryptedKey".equals(type)) {
                            String uri = rmAttr.getNamedItem("URI").getNodeValue();
                            Element ek = DOM.getElementByAttribute((Node)encData.getOwnerDocument().getDocumentElement(), (String)"Id", null, (String)uri.substring(1));
                            Key key = SsfDataXML.decryptKey(ek, profile, symAlgURI, null);
                            if (key != null) {
                                ekOut[0] = ek;
                                loc.exiting((Object)"key");
                                return key;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            cat.warningT(loc, "Could not cast key info node EXCEPTION " + e);
        }
        loc.exiting((Object)"null");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

