/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfData;
import com.sap.security.api.ssf.ISsfPab;
import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.server.ssf.SsfInvalidAlgException;
import com.sap.security.core.server.ssf.SsfInvalidDataException;
import com.sap.security.core.server.ssf.SsfInvalidKeyException;
import com.sap.security.core.server.ssf.SsfSigRcpInfo;
import com.sap.security.core.server.ssf.SsfSigRcpList;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.smime.EncryptedContent;
import iaik.security.smime.SMimeBodyPart;
import iaik.security.smime.SMimeMultipart;
import iaik.security.smime.SMimeParameters;
import iaik.security.smime.SignedContent;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SsfDataSMIME
implements ISsfData {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfDataSMIME == null ? (class$com$sap$security$core$server$ssf$SsfDataSMIME = SsfDataSMIME.class$("com.sap.security.core.server.ssf.SsfDataSMIME")) : class$com$sap$security$core$server$ssf$SsfDataSMIME));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private MimeMessage data = null;
    private Session sess = null;
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfDataSMIME;

    public SsfDataSMIME(InputStream is, Session sess) throws SsfInvalidDataException {
        String me = "SsfDataSMIME(InputStream is, Session sess) ";
        loc.entering("SsfDataSMIME(InputStream is, Session sess) ", new Object[]{is, sess});
        try {
            this.data = new MimeMessage(sess, is);
            this.sess = sess;
        }
        catch (MessagingException e) {
            cat.warningT(loc, "Load MIME data EXCEPTION " + (Object)((Object)e));
            SsfInvalidDataException ex = new SsfInvalidDataException("No MIME data provided");
            loc.throwing("SsfDataSMIME(InputStream is, Session sess) ", (Throwable)ex);
            throw ex;
        }
        loc.exiting();
    }

    public SsfDataSMIME(MimeMessage mess, Session sess) throws SsfInvalidDataException {
        String me = "SsfDataPKCS7(InputStream is, Session sess)";
        loc.entering("SsfDataPKCS7(InputStream is, Session sess)", new Object[]{mess, sess});
        if (mess == null) {
            cat.warningT(loc, "No MIME data provided: null reference");
            SsfInvalidDataException ex = new SsfInvalidDataException("No MIME data provided");
            loc.throwing("SsfDataPKCS7(InputStream is, Session sess)", (Throwable)ex);
            throw ex;
        }
        this.data = mess;
        this.sess = sess;
        loc.exiting();
    }

    public boolean sign(ISsfProfile profile) throws SsfInvalidKeyException {
        String me = "sign(ISsfProfile profile)";
        loc.entering("sign(ISsfProfile profile)", new Object[]{profile});
        boolean res = false;
        try {
            res = this.sign(profile, "SHA", 2, false);
        }
        catch (SsfInvalidAlgException e) {
            loc.errorT("Set SHA algorithm EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)";
        loc.entering("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", new Object[]{profile, mdAlg, new Integer(incCerts), new Boolean(detached)});
        if (!mdAlg.equals("SHA")) {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Invalid message digest algorithm " + mdAlg);
            loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
            throw ex;
        }
        SignedContent sig = null;
        sig = detached ? new SignedContent(false) : new SignedContent(true, "signed-data");
        try {
            DataHandler dh = this.data.getDataHandler();
            Object cont = dh.getContent();
            if (detached && cont instanceof MimeMultipart) {
                MimeMultipart mmp = new MimeMultipart(dh.getDataSource());
                ContentType mmpContType = new ContentType(mmp.getContentType());
                SMimeMultipart smmp = null;
                smmp = "multipart".equals(mmpContType.getPrimaryType()) ? new SMimeMultipart(mmpContType.getSubType()) : new SMimeMultipart();
                int i = 0;
                while (i < mmp.getCount()) {
                    MimeBodyPart bp = (MimeBodyPart)mmp.getBodyPart(i);
                    SMimeBodyPart smbp = new SMimeBodyPart();
                    smbp.setDataHandler(bp.getDataHandler());
                    Enumeration en = bp.getAllHeaders();
                    while (en.hasMoreElements()) {
                        Header hd = (Header)en.nextElement();
                        smbp.setHeader(hd.getName(), hd.getValue());
                    }
                    smmp.addBodyPart((BodyPart)smbp);
                    ++i;
                }
                sig.setContent((Multipart)smmp);
            } else {
                String encoding = this.data.getEncoding();
                if (encoding != null) {
                    sig.setContentContentTransferEncoding(encoding);
                }
                sig.setDataHandler(dh);
            }
        }
        catch (Exception e) {
            loc.errorT("Set content EXCEPTION " + e);
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        java.security.cert.X509Certificate[] certs = profile.getCertificateChain();
        int certsLen = certs == null ? 0 : certs.length;
        switch (incCerts) {
            case 0: {
                certsLen = 0;
                break;
            }
            case 1: {
                if (certsLen <= 0) break;
                certsLen = 1;
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (certsLen <= 1) break;
                --certsLen;
            }
        }
        ArrayList<X509Certificate> certarray = new ArrayList<X509Certificate>(certsLen);
        int i = 0;
        while (i < certsLen) {
            X509Certificate iaikcert = null;
            try {
                iaikcert = new X509Certificate(certs[i].getEncoded());
                certarray.add(iaikcert);
            }
            catch (CertificateException e) {
                loc.errorT("Get iaikcert EXCEPTION " + e);
            }
            if (iaikcert != null) {
                certarray.add(iaikcert);
            }
            ++i;
        }
        X509Certificate[] iaikcerts = new X509Certificate[]{};
        iaikcerts = certarray.toArray(iaikcerts);
        sig.setCertificates(iaikcerts);
        PrivateKey signerKey = profile.getPrivateKey();
        java.security.cert.X509Certificate signerCert = profile.getCertificate();
        if (signerKey == null || signerCert == null) {
            SsfInvalidKeyException ex = new SsfInvalidKeyException("Private key or certificate of signer not available");
            loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
            throw ex;
        }
        try {
            sig.setSigner((RSAPrivateKey)signerKey, (X509Certificate)signerCert);
        }
        catch (Exception e) {
            SsfInvalidKeyException ex = new SsfInvalidKeyException("Private key or certificate of signer cannot be used: " + e);
            loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
            throw ex;
        }
        boolean res = false;
        try {
            MimeMessage msg = new MimeMessage(this.sess);
            msg.setContent((Object)sig, sig.getContentType());
            sig.setHeaders((Message)msg);
            msg.saveChanges();
            this.data = new MimeMessage(msg);
            res = true;
        }
        catch (Exception e) {
            loc.errorT("Create signed message EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList sigList) ";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList sigList) ", new Object[]{pab, sigList});
        boolean res = this.verify(pab, sigList, null);
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, java.security.cert.X509Certificate cert) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList signer, ISsfData input, X509Certificate cert)";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList signer, ISsfData input, X509Certificate cert)", new Object[]{pab, sigList, input, cert});
        loc.infoT("Parameter input is ignored");
        boolean res = this.verify(pab, sigList, cert);
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList, java.security.cert.X509Certificate cert) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList sigList, X509Certificate cert)";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList sigList, X509Certificate cert)", new Object[]{pab, sigList, cert});
        SignedContent sig = null;
        try {
            sig = (SignedContent)this.data.getContent();
        }
        catch (Exception e) {
            cat.warningT(loc, "Get signed MIME data EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("No signed MIME data provided");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        boolean res = false;
        if (sigList == null) {
            sigList = new SsfSigRcpList();
        } else {
            sigList.clear();
        }
        SsfSigRcpInfo sigInfo = new SsfSigRcpInfo();
        try {
            if (cert == null) {
                sigInfo.cert = sig.verify();
            } else {
                sig.verify(cert.getPublicKey());
                sigInfo.cert = cert;
            }
        }
        catch (SignatureException e) {
            loc.infoT("Verify signature EXCEPTION " + e);
            sigInfo.rc = 1;
        }
        sigList.add(sigInfo);
        if (pab != null) {
            X509Certificate[] certs = sig.getCertificates();
            int len = certs == null ? 0 : certs.length;
            int i = 0;
            while (i < len) {
                pab.addUntrustedCertificate((java.security.cert.X509Certificate)certs[i]);
                ++i;
            }
        }
        if (res = sigList.checkInitialCerts(pab, false)) {
            try {
                DataHandler dh = sig.getDataHandler();
                this.data = new MimeMessage(this.sess);
                this.data.setDataHandler(dh);
            }
            catch (Exception e) {
                loc.errorT("Get inner content EXCEPTION " + e);
                res = false;
            }
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(SsfSigRcpList rcpList, ISsfPab pab) throws SsfInvalidKeyException {
        String me = "encrypt(SsfSigRcpList rcpList, ISsfPab pab)";
        loc.entering("encrypt(SsfSigRcpList rcpList, ISsfPab pab)", new Object[]{rcpList, pab});
        boolean res = false;
        try {
            res = this.encrypt(rcpList, pab, "DES_EDE3_CBC");
        }
        catch (SsfInvalidAlgException e) {
            loc.errorT("Set DES_EDE3_CBC encryption EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)";
        loc.entering("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", new Object[]{rcpList, pab, symAlg});
        EncryptedContent env = new EncryptedContent();
        try {
            String encoding = this.data.getEncoding();
            if (encoding != null) {
                env.setContentContentTransferEncoding(encoding);
            }
            env.setDataHandler(this.data.getDataHandler());
        }
        catch (MessagingException e) {
            loc.errorT("Set data handler EXCEPTION " + (Object)((Object)e));
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        AlgorithmID algID = null;
        int keyLength = -1;
        if (symAlg.equals("AES128_CBC")) {
            algID = AlgorithmID.aes128_CBC;
        } else if (symAlg.equals("DES_EDE3_CBC")) {
            algID = AlgorithmID.des_EDE3_CBC;
        } else if (symAlg.equals("RC2_40_CBC")) {
            algID = AlgorithmID.rc2_CBC;
            keyLength = 40;
        } else if (symAlg.equals("RC2_CBC")) {
            algID = AlgorithmID.rc2_CBC;
            keyLength = 128;
        } else {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown symmetric encryption algorithm " + symAlg);
            loc.throwing("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", (Throwable)ex);
            throw ex;
        }
        env.setEncryptionAlgorithm(algID, keyLength);
        env.setSMimeType();
        if (rcpList == null || rcpList.size() == 0) {
            cat.warningT(loc, "Empty recipient list, cannot perform encryption");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        rcpList.setInitial();
        if (!rcpList.checkInitialCerts(pab, true)) {
            cat.warningT(loc, "Recipient list contains untrusted certificates");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        int i = 0;
        while (i < rcpList.size()) {
            X509Certificate rcpCert = (X509Certificate)rcpList.get((int)i).cert;
            String asymAlgName = rcpCert.getPublicKey().getAlgorithm();
            if (asymAlgName.equals("RSA")) {
                try {
                    env.addRecipient(rcpCert, AlgorithmID.rsaEncryption);
                    rcpList.get((int)i).rc = 0;
                }
                catch (Exception e) {
                    loc.errorT("Set RSA encryption EXCEPTION " + e);
                    loc.exiting((Object)new Boolean(false));
                    return false;
                }
            } else {
                rcpList.get((int)i).rc = 7;
                SsfInvalidKeyException ex = new SsfInvalidKeyException("Invalid public key algorithm " + asymAlgName);
                loc.throwing("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", (Throwable)ex);
                throw ex;
            }
            ++i;
        }
        boolean res = false;
        try {
            MimeMessage msg = new MimeMessage(this.sess);
            msg.setContent((Object)env, env.getContentType());
            env.setHeaders((Message)msg);
            msg.saveChanges();
            this.data = new MimeMessage(msg);
            res = true;
        }
        catch (MessagingException e) {
            loc.errorT("Create encrypted message EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean decrypt(ISsfProfile profile) throws SsfInvalidKeyException, SsfInvalidDataException {
        String me = "decrypt(ISsfProfile profile)";
        loc.entering("decrypt(ISsfProfile profile)", new Object[]{profile});
        EncryptedContent env = null;
        try {
            env = (EncryptedContent)this.data.getContent();
        }
        catch (Exception e) {
            cat.warningT(loc, "Get encrypted MIME data EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("No encrypted MIME data provided");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        PrivateKey rcpKey = profile.getPrivateKey();
        java.security.cert.X509Certificate rcpCert = profile.getCertificate();
        if (rcpKey == null || rcpCert == null) {
            SsfInvalidKeyException ex = new SsfInvalidKeyException("Private key or certificate of recipient not available");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        int rcpIndex = env.getRecipientInfoIndex((X509Certificate)rcpCert);
        boolean res = false;
        try {
            env.decryptSymmetricKey(rcpKey, rcpIndex);
            res = true;
        }
        catch (Exception e) {
            cat.warningT(loc, "Could not decrypt secret key");
        }
        if (res) {
            try {
                DataHandler dh = env.getDataHandler();
                this.data = new MimeMessage(this.sess);
                this.data.setDataHandler(dh);
            }
            catch (Exception e) {
                loc.infoT("Get inner content EXCEPTION " + e);
                res = false;
            }
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public void setNewContentTypes(boolean newContentTypes) {
        String me = "useNewContentTypes(boolean newContentTypes)";
        loc.entering("useNewContentTypes(boolean newContentTypes)", new Object[]{new Boolean(newContentTypes)});
        SMimeParameters.useNewContentTypes((boolean)newContentTypes);
        loc.exiting();
    }

    public boolean writeTo(OutputStream out) throws IOException {
        String me = "writeTo(OutputStream out)";
        loc.entering("writeTo(OutputStream out)", new Object[]{out});
        boolean res = false;
        try {
            this.data.writeTo(out);
            res = true;
        }
        catch (MessagingException e) {
            loc.errorT("Write MIME multipart EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public MimeMessage getDataSMIME() {
        String me = "getDataSMIME()";
        loc.entering("getDataSMIME()");
        loc.exiting((Object)this.data);
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

