/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.ssf;

import com.sap.security.api.ssf.ISsfData;
import com.sap.security.api.ssf.ISsfPab;
import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.server.ssf.SsfInvalidAlgException;
import com.sap.security.core.server.ssf.SsfInvalidDataException;
import com.sap.security.core.server.ssf.SsfInvalidKeyException;
import com.sap.security.core.server.ssf.SsfSigRcpInfo;
import com.sap.security.core.server.ssf.SsfSigRcpList;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.EnvelopedData;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedData;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.utils.CryptoUtils;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.util.ArrayList;
import javax.crypto.SecretKey;

public class SsfDataPKCS7
implements ISsfData {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$ssf$SsfDataPKCS7 == null ? (class$com$sap$security$core$server$ssf$SsfDataPKCS7 = SsfDataPKCS7.class$("com.sap.security.core.server.ssf.SsfDataPKCS7")) : class$com$sap$security$core$server$ssf$SsfDataPKCS7));
    private static final Category cat = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SSF");
    private byte[] data = null;
    static /* synthetic */ Class class$com$sap$security$core$server$ssf$SsfDataPKCS7;

    public SsfDataPKCS7(InputStream in) throws IOException {
        String me = "SsfDataPKCS7(InputStream in)";
        loc.entering("SsfDataPKCS7(InputStream in)", new Object[]{in});
        this.data = new byte[in.available()];
        in.read(this.data);
        loc.exiting();
    }

    public boolean sign(ISsfProfile profile) throws SsfInvalidKeyException {
        String me = "sign(ISsfProfile profile)";
        loc.entering("sign(ISsfProfile profile)", new Object[]{profile});
        boolean res = false;
        try {
            res = this.sign(profile, "SHA", 2, false);
        }
        catch (SsfInvalidAlgException e) {
            loc.errorT("Set SHA algorithm EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)";
        loc.entering("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", new Object[]{profile, mdAlg, new Integer(incCerts), new Boolean(detached)});
        AlgorithmID mdID = null;
        if (mdAlg.equals("SHA")) {
            mdID = AlgorithmID.sha;
        } else {
            if (!mdAlg.equals("MD5")) {
                SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown message digest algorithm " + mdAlg);
                loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
                throw ex;
            }
            mdID = AlgorithmID.md5;
        }
        SignedData sig = null;
        sig = detached ? new SignedData(this.data, 2) : new SignedData(this.data, 1);
        PrivateKey signerKey = profile.getPrivateKey();
        java.security.cert.X509Certificate signerCert = profile.getCertificate();
        if (signerKey == null || signerCert == null) {
            SsfInvalidKeyException ex = new SsfInvalidKeyException("Private key or certificate of signer not available");
            loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
            throw ex;
        }
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(signerCert);
        SignerInfo signerinfo = new SignerInfo(iasn, mdID, signerKey);
        Attribute[] attributes = new Attribute[2];
        ChoiceOfTime cot = new ChoiceOfTime();
        attributes[0] = new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data});
        attributes[1] = new Attribute(ObjectID.signingTime, new ASN1Object[]{cot.toASN1Object()});
        signerinfo.setAuthenticatedAttributes(attributes);
        try {
            sig.addSignerInfo(signerinfo);
        }
        catch (NoSuchAlgorithmException e) {
            cat.warningT(loc, "Set message digest algorithm EXCEPTION " + e);
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Invalid message digest algorithm " + mdID);
            loc.throwing("sign(ISsfProfile profile, String mdAlg, int incCerts, boolean detached)", (Throwable)ex);
            throw ex;
        }
        java.security.cert.X509Certificate[] certs = profile.getCertificateChain();
        int certsLen = certs == null ? 0 : certs.length;
        switch (incCerts) {
            case 0: {
                certsLen = 0;
                break;
            }
            case 1: {
                if (certsLen <= 0) break;
                certsLen = 1;
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (certsLen <= 1) break;
                --certsLen;
            }
        }
        ArrayList<X509Certificate> certarray = new ArrayList<X509Certificate>(certsLen);
        int i = 0;
        while (i < certsLen) {
            try {
                X509Certificate iaikcert = new X509Certificate(certs[i].getEncoded());
                certarray.add(iaikcert);
            }
            catch (Exception e) {
                cat.warningT(loc, "Get iaikcert EXCEPTION " + e);
            }
            ++i;
        }
        X509Certificate[] iaikcerts = new X509Certificate[]{};
        iaikcerts = certarray.toArray(iaikcerts);
        sig.setCertificates(iaikcerts);
        if (detached) {
            InputStream is = sig.getInputStream();
            try {
                is.read();
            }
            catch (IOException e) {
                cat.warningT(loc, "Read input data EXCEPTION " + e);
                loc.exiting((Object)new Boolean(false));
                return false;
            }
        }
        ContentInfo cont = null;
        boolean res = false;
        if (signerKey instanceof DSAPrivateKey) {
            res = this.setDigestDSA(signerinfo, signerKey);
            if (!res) {
                cat.warningT(loc, "Create DSA signature value FAILED");
                loc.exiting((Object)new Boolean(res));
                return res;
            }
            cont = this.setAlgIdDSA(new ContentInfo((Content)sig));
        } else {
            cont = new ContentInfo((Content)sig);
        }
        res = false;
        try {
            this.data = cont.toByteArray();
            res = true;
        }
        catch (Exception e) {
            cat.warningT(loc, "Write buffer EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList sigList) ";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList sigList) ", new Object[]{pab, sigList});
        boolean res = this.verify(pab, sigList, null, null);
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, java.security.cert.X509Certificate cert) throws SsfInvalidDataException {
        String me = "verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)";
        loc.entering("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", new Object[]{pab, input, sigList, cert});
        if (input != null && !(input instanceof SsfDataPKCS7)) {
            SsfInvalidDataException ex = new SsfInvalidDataException("Wrong input data provided");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        InputStream asn1DataStream = null;
        ASN1Object asn1Data = null;
        try {
            asn1Data = DerCoder.decode((byte[])this.data);
            ContentInfo cont = new ContentInfo(asn1Data);
            asn1DataStream = cont.getContentInputStream();
        }
        catch (Exception e) {
            cat.warningT(loc, "ASN1 decode signed data EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("ASN1 decode signed data failed");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        SignedData sig = null;
        try {
            if (input == null) {
                sig = new SignedData(asn1DataStream);
            } else {
                SsfDataPKCS7 inputp7 = (SsfDataPKCS7)input;
                AlgorithmID[] algID = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
                sig = new SignedData(inputp7.getDataPKCS7(), algID);
            }
        }
        catch (Exception e) {
            cat.warningT(loc, "Parse PKCS#7 signed data EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("Parse PKCS#7 signed data failed");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        InputStream is = sig.getInputStream();
        if (is == null) {
            SsfInvalidDataException ex = new SsfInvalidDataException("No PKCS#7 content provided");
            loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
            throw ex;
        }
        try {
            is.read();
        }
        catch (IOException e) {
            cat.warningT(loc, "Update hash values EXCEPTION " + e);
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        if (input != null) {
            try {
                sig.decode(asn1DataStream);
            }
            catch (Exception e) {
                cat.warningT(loc, "Parse PKCS#7 signature EXCEPTION " + e);
                SsfInvalidDataException ex = new SsfInvalidDataException("Parse PKCS#7 signature failed");
                loc.throwing("verify(ISsfPab pab, SsfSigRcpList sigList, ISsfData input, X509Certificate cert)", (Throwable)ex);
                throw ex;
            }
        }
        boolean res = false;
        if (sigList == null) {
            sigList = new SsfSigRcpList();
        } else {
            sigList.clear();
        }
        SignerInfo[] sigInfos = sig.getSignerInfos();
        int i = 0;
        while (i < sigInfos.length) {
            SsfSigRcpInfo sigInfo;
            block25: {
                sigInfo = new SsfSigRcpInfo();
                IssuerAndSerialNumber isn = sigInfos[i].getIssuerAndSerialNumber();
                if (cert == null || isn.isIssuerOf(cert)) {
                    String dea = sigInfos[i].getDigestEncryptionAlgorithm().getName();
                    try {
                        if (dea.indexOf("DSA") >= 0 || dea.indexOf("dsa") >= 0) {
                            sigInfo.cert = this.verifyDSA(sig, sigInfos[i], cert);
                            break block25;
                        }
                        if (cert == null) {
                            sigInfo.cert = sig.verify(i);
                            break block25;
                        }
                        sig.verify(cert.getPublicKey(), i);
                        sigInfo.cert = cert;
                    }
                    catch (SignatureException e) {
                        loc.infoT("Verify signature EXCEPTION " + e);
                        sigInfo.rc = 1;
                    }
                } else {
                    sigInfo.rc = 2;
                }
            }
            sigList.add(sigInfo);
            ++i;
        }
        if (pab != null) {
            X509Certificate[] certs = sig.getCertificates();
            int len = certs == null ? 0 : certs.length;
            int i2 = 0;
            while (i2 < len) {
                pab.addUntrustedCertificate((java.security.cert.X509Certificate)certs[i2]);
                ++i2;
            }
        }
        if (res = sigList.checkInitialCerts(pab, false)) {
            this.data = sig.getContent();
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(SsfSigRcpList rcpList, ISsfPab pab) throws SsfInvalidKeyException {
        String me = "encrypt(SsfSigRcpList rcpList, ISsfPab pab)";
        loc.entering("encrypt(SsfSigRcpList rcpList, ISsfPab pab)", new Object[]{rcpList, pab});
        boolean res = false;
        try {
            res = this.encrypt(rcpList, pab, "AES128_CBC");
        }
        catch (SsfInvalidAlgException e) {
            loc.errorT("Set AES128_CBC encryption EXCEPTION " + e);
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg) throws SsfInvalidKeyException, SsfInvalidAlgException {
        String me = "encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)";
        loc.entering("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", new Object[]{rcpList, pab, symAlg});
        EnvelopedData env = null;
        AlgorithmID algID = null;
        int keyLength = -1;
        if (symAlg.equals("AES128_CBC")) {
            algID = AlgorithmID.aes128_CBC;
        } else if (symAlg.equals("DES_EDE3_CBC")) {
            algID = AlgorithmID.des_EDE3_CBC;
        } else if (symAlg.equals("RC2_40_CBC")) {
            algID = AlgorithmID.rc2_CBC;
            keyLength = 40;
        } else if (symAlg.equals("RC2_CBC")) {
            algID = AlgorithmID.rc2_CBC;
            keyLength = 128;
        } else {
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Unknown symmetric encryption algorithm " + symAlg);
            loc.throwing("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", (Throwable)ex);
            throw ex;
        }
        try {
            env = new EnvelopedData(this.data, algID, keyLength);
        }
        catch (NoSuchAlgorithmException e) {
            cat.warningT(loc, "Set algorithm id EXCEPTION " + e);
            SsfInvalidAlgException ex = new SsfInvalidAlgException("Invalid symmetric encryption algorithm " + algID);
            loc.throwing("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", (Throwable)ex);
            throw ex;
        }
        if (rcpList == null || rcpList.size() == 0) {
            cat.warningT(loc, "Empty recipient list, cannot perform encryption");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        rcpList.setInitial();
        if (!rcpList.checkInitialCerts(pab, true)) {
            cat.warningT(loc, "Recipient list contains untrusted certificates");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        int rcpListSize = rcpList.size();
        RecipientInfo[] rcpInfo = new RecipientInfo[rcpListSize];
        int i = 0;
        while (i < rcpListSize) {
            java.security.cert.X509Certificate rcpCert = rcpList.get((int)i).cert;
            String asymAlgName = rcpCert.getPublicKey().getAlgorithm();
            if (asymAlgName.equals("RSA")) {
                rcpList.get((int)i).rc = 0;
                try {
                    rcpInfo[i] = new RecipientInfo(rcpCert, AlgorithmID.rsaEncryption);
                }
                catch (NoSuchAlgorithmException e) {
                    loc.errorT("Set RSA encryption EXCEPTION " + e);
                }
            } else {
                rcpList.get((int)i).rc = 7;
                SsfInvalidKeyException ex = new SsfInvalidKeyException("Invalid public key algorithm " + asymAlgName);
                loc.throwing("encrypt(SsfSigRcpList rcpList, ISsfPab pab, String symAlg)", (Throwable)ex);
                throw ex;
            }
            ++i;
        }
        env.setRecipientInfos(rcpInfo);
        boolean res = false;
        ContentInfo cont = new ContentInfo((Content)env);
        try {
            this.data = cont.toByteArray();
            res = true;
        }
        catch (PKCSException e) {
            cat.warningT(loc, "Write buffer EXCEPTION " + (Object)((Object)e));
        }
        loc.exiting((Object)new Boolean(res));
        return res;
    }

    public boolean decrypt(ISsfProfile profile) throws SsfInvalidKeyException, SsfInvalidDataException {
        String me = "decrypt(ISsfProfile profile)";
        loc.entering("decrypt(ISsfProfile profile)", new Object[]{profile});
        EnvelopedData env = null;
        ASN1Object asn1Data = null;
        try {
            asn1Data = DerCoder.decode((byte[])this.data);
            ContentInfo cont = new ContentInfo(asn1Data);
            env = new EnvelopedData(cont.getContentInputStream());
        }
        catch (Exception e) {
            cat.warningT(loc, "ASN1 decode data EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("No PKCS#7 enveloped data provided");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        PrivateKey rcpKey = profile.getPrivateKey();
        java.security.cert.X509Certificate rcpCert = profile.getCertificate();
        if (rcpKey == null || rcpCert == null) {
            SsfInvalidKeyException ex = new SsfInvalidKeyException("Private key or certificate of recipient not available");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        RecipientInfo rcpInfo = env.getRecipientInfo(rcpCert);
        if (rcpInfo == null) {
            cat.warningT(loc, "Get recipient info for cert FAILED");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        SecretKey secKey = null;
        try {
            secKey = rcpInfo.decryptKey(rcpKey);
        }
        catch (Exception e) {
            cat.warningT(loc, "Decrypt secret key EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("Cannot decrypt secret key");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        try {
            env.setupCipher((Key)secKey);
        }
        catch (Exception e) {
            cat.warningT(loc, "Decrypt content EXCEPTION " + e);
            SsfInvalidDataException ex = new SsfInvalidDataException("Cannot decrypt content");
            loc.throwing("decrypt(ISsfProfile profile)", (Throwable)ex);
            throw ex;
        }
        this.data = env.getContent();
        loc.exiting((Object)new Boolean(true));
        return true;
    }

    public boolean writeTo(OutputStream out) throws IOException {
        String me = "writeTo(OutputStream out)";
        loc.entering("writeTo(OutputStream out)", new Object[]{out});
        out.write(this.data);
        loc.exiting((Object)new Boolean(true));
        return true;
    }

    public byte[] getDataPKCS7() {
        String me = "getDataPKCS7()";
        loc.entering("getDataPKCS7()");
        loc.exiting((Object)this.data);
        return this.data;
    }

    public String toString() {
        String info = null;
        ContentInfo cont = null;
        try {
            ASN1Object obj = DerCoder.decode((byte[])this.data);
            cont = new ContentInfo(obj);
        }
        catch (Exception e) {
            loc.infoT("Parse ASN1 data EXCEPTION " + e);
        }
        info = cont == null ? "Raw data of length " + this.data.length : cont.toString();
        return info;
    }

    private boolean setDigestDSA(SignerInfo sigInfo, PrivateKey privKey) {
        String me = "setDigestDSA(SignerInfo sigInfo, PrivateKey privKey)";
        loc.entering("setDigestDSA(SignerInfo sigInfo, PrivateKey privKey)", new Object[]{sigInfo, privKey == null ? "null" : "(PrivateKey)"});
        MessageDigest mdAlg = null;
        byte[] dataDigest = null;
        byte[] attrDigest = null;
        byte[] encrDigest = null;
        String mdAlgName = sigInfo.getDigestAlgorithm().getName();
        if (!mdAlgName.equalsIgnoreCase("SHA")) {
            cat.warningT(loc, "Use hash algorithm FAILED - " + mdAlgName + " with DSA not supported");
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        try {
            mdAlg = MessageDigest.getInstance(mdAlgName);
        }
        catch (NoSuchAlgorithmException e) {
            cat.warningT(loc, "Get digest algorithm EXCEPTION " + e);
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        mdAlg.reset();
        mdAlg.update(this.data);
        dataDigest = mdAlg.digest();
        Attribute dataDigestAttr = new Attribute(ObjectID.messageDigest, new ASN1Object[]{new OCTET_STRING(dataDigest)});
        Attribute[] authAttr0 = sigInfo.getAuthenticatedAttributes();
        int len = authAttr0.length;
        Attribute[] authAttr = new Attribute[len + 1];
        int i = 0;
        while (i < len) {
            authAttr[i] = authAttr0[i];
            ++i;
        }
        authAttr[len] = dataDigestAttr;
        sigInfo.setAuthenticatedAttributes(authAttr);
        byte[] b = null;
        try {
            b = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])authAttr));
        }
        catch (CodingException e) {
            loc.errorT("ASN1 encode EXCEPTION " + (Object)((Object)e));
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        mdAlg.reset();
        mdAlg.update(b);
        attrDigest = mdAlg.digest();
        Signature dsa = null;
        try {
            dsa = Signature.getInstance("rawDSA");
        }
        catch (Exception e) {
            loc.errorT("Get rawDSA instance EXCEPTION " + e);
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        try {
            dsa.initSign(privKey);
        }
        catch (InvalidKeyException e) {
            cat.warningT(loc, "Set private key EXCEPTION " + e);
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        try {
            dsa.update(attrDigest);
            encrDigest = dsa.sign();
        }
        catch (SignatureException e) {
            loc.errorT("Compute signature value EXCEPTION " + e);
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        sigInfo.setEncryptedDigest(encrDigest);
        loc.exiting((Object)new Boolean(true));
        return true;
    }

    private ContentInfo setAlgIdDSA(ContentInfo cont) {
        String me = "setAlgIdDSA(ContentInfo cont)";
        loc.entering("setAlgIdDSA(ContentInfo cont)", new Object[]{cont});
        ContentInfo newCont = null;
        try {
            ASN1Object contentASN1 = cont.toASN1Object();
            ASN1Object sigDataASN1 = (ASN1Object)contentASN1.getComponentAt(1).getValue();
            int i = sigDataASN1.countComponents();
            ConstructedType sigInfoCT = (ConstructedType)sigDataASN1.getComponentAt(i - 1).getComponentAt(0);
            SEQUENCE digAlgID = new SEQUENCE(false);
            ObjectID objID = new ObjectID("1.2.840.10040.4.3", "DSAwithSHA1");
            digAlgID.addComponent((ASN1Object)objID);
            digAlgID.setIndefiniteLength(false);
            sigInfoCT.setComponent(4, (ASN1Object)digAlgID);
            newCont = new ContentInfo(contentASN1);
        }
        catch (Exception e) {
            loc.errorT("Set DSA algorithm id EXCEPTION " + e);
        }
        loc.exiting(newCont);
        return newCont;
    }

    private java.security.cert.X509Certificate verifyDSA(SignedData sig, SignerInfo sigInfo, java.security.cert.X509Certificate cert) {
        String me = "verifyDSA(SignedData sig, SignerInfo sigInfo, X509Certificate cert)";
        loc.entering("verifyDSA(SignedData sig, SignerInfo sigInfo, X509Certificate cert)", new Object[]{sig, sigInfo, cert});
        MessageDigest mdAlg = null;
        byte[] dataDigest = null;
        byte[] attrDigest = null;
        String mdAlgName = sigInfo.getDigestAlgorithm().getName();
        if (!mdAlgName.equalsIgnoreCase("SHA")) {
            cat.warningT(loc, "Use hash algorithm FAILED - " + mdAlgName + " with DSA not supported");
            loc.exiting((Object)null);
            return null;
        }
        try {
            mdAlg = MessageDigest.getInstance(mdAlgName);
        }
        catch (NoSuchAlgorithmException e) {
            cat.warningT(loc, "Get digest algorithm EXCEPTION " + e);
            loc.exiting((Object)null);
            return null;
        }
        mdAlg.reset();
        mdAlg.update(sig.getContent());
        dataDigest = mdAlg.digest();
        Attribute[] authAttr = sigInfo.getAuthenticatedAttributes();
        boolean cmpResult = false;
        try {
            ASN1Object messDigestASN1 = authAttr[authAttr.length - 1].toASN1Object();
            OCTET_STRING osDigest = (OCTET_STRING)messDigestASN1.getComponentAt(1).getComponentAt(0);
            cmpResult = CryptoUtils.equalsBlock((byte[])osDigest.getWholeValue(), (byte[])dataDigest);
        }
        catch (Exception e) {
            loc.errorT("Compare message digest EXCEPTION " + e);
        }
        if (!cmpResult) {
            loc.infoT("Message digest mismatch");
            loc.exiting((Object)null);
            return null;
        }
        byte[] b = null;
        try {
            b = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])authAttr));
        }
        catch (CodingException e) {
            loc.errorT("ASN1 encode authAttr EXCEPTION " + (Object)((Object)e));
            loc.exiting((Object)null);
            return null;
        }
        mdAlg.reset();
        mdAlg.update(b);
        attrDigest = mdAlg.digest();
        Signature dsa = null;
        try {
            dsa = Signature.getInstance("rawDSA");
        }
        catch (Exception e) {
            loc.errorT("Get rawDSA instance EXCEPTION " + e);
            loc.exiting((Object)null);
            return null;
        }
        if (cert == null) {
            try {
                cert = sig.getCertificate(sigInfo.getIssuerAndSerialNumber());
            }
            catch (PKCSException e) {
                cat.warningT(loc, "Get signer certificate EXCEPTION " + (Object)((Object)e));
                loc.exiting((Object)null);
                return null;
            }
        }
        try {
            dsa.initVerify(cert.getPublicKey());
        }
        catch (InvalidKeyException e) {
            loc.errorT("Set public key EXCEPTION " + e);
            loc.exiting((Object)null);
            return null;
        }
        try {
            dsa.update(attrDigest);
            boolean verifyRes = dsa.verify(sigInfo.getEncryptedDigest());
            if (!verifyRes) {
                cert = null;
            }
        }
        catch (SignatureException e) {
            loc.errorT("Set public key EXCEPTION " + e);
            loc.exiting((Object)null);
            return null;
        }
        loc.exiting((Object)cert);
        return cert;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

