/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.SerializedProfile;
import sqlj.runtime.profile.TypeInfo;

public abstract class Profile
implements Serializable {
    private static final Location LOCATION = Location.getLocation((Class)(class$sqlj$runtime$profile$Profile == null ? (class$sqlj$runtime$profile$Profile = Profile.class$("sqlj.runtime.profile.Profile")) : class$sqlj$runtime$profile$Profile));
    private transient Loader m_loader = null;
    private transient Hashtable m_types = null;
    static final long serialVersionUID = 6176398232003186292L;
    static /* synthetic */ Class class$sqlj$runtime$profile$Profile;
    static /* synthetic */ Class class$sqlj$runtime$profile$SerializedProfile;

    public Profile(Loader loader) {
        if (loader == null) {
            loader = new DefaultLoader(null);
        }
        this.setLoader(loader);
    }

    public abstract String getProfileName();

    public abstract String getContextName();

    public abstract long getTimestamp();

    public abstract ProfileData getProfileData();

    public abstract ConnectedProfile getConnectedProfile(Connection var1) throws SQLException;

    public abstract void registerCustomization(Customization var1);

    public abstract void registerCustomization(Customization var1, Customization var2);

    public abstract void replaceCustomization(Customization var1, Customization var2);

    public abstract void deregisterCustomization(Customization var1);

    public abstract Enumeration getCustomizations();

    public Loader getLoader() {
        return this.m_loader;
    }

    private void setLoader(Loader loader) {
        this.m_loader = loader;
        this.m_types = this.newTypeTable();
    }

    private Hashtable newTypeTable() {
        Hashtable<String, Class<Object>> primitives = new Hashtable<String, Class<Object>>();
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("void", Void.TYPE);
        return primitives;
    }

    public Class getJavaType(TypeInfo type) {
        return this.getJavaType(type.getJavaTypeName());
    }

    public Class getJavaType(String className) {
        Class cls = (Class)this.m_types.get(className);
        if (cls == null) {
            try {
                int ndx = className.lastIndexOf(91);
                if (ndx != -1) {
                    int arrayDepth = ndx + 1;
                    String baseClassName = className.substring(ndx + 1);
                    cls = (Class)this.m_types.get(baseClassName);
                    if (cls == null) {
                        cls = this.m_loader.loadClass(baseClassName);
                    }
                    int i = 0;
                    while (i < arrayDepth) {
                        cls = Array.newInstance(cls, 0).getClass();
                        ++i;
                    }
                } else {
                    cls = this.m_loader.loadClass(className);
                }
                this.m_types.put(className, cls);
            }
            catch (ClassNotFoundException e) {
                LOCATION.catching((Throwable)e);
                throw new NoClassDefFoundError(className);
            }
        }
        return cls;
    }

    public static Profile instantiate(Loader loader, String profileName) throws IOException, ClassNotFoundException {
        if (loader == null) {
            loader = new DefaultLoader(null);
        }
        Profile result = null;
        String serName = profileName.replace('.', '/').concat(".ser");
        InputStream ins = loader.getResourceAsStream(serName);
        if (ins != null) {
            result = Profile.instantiate(loader, ins);
        }
        if (result == null) {
            Class cl;
            if ((class$sqlj$runtime$profile$Profile == null ? (class$sqlj$runtime$profile$Profile = Profile.class$("sqlj.runtime.profile.Profile")) : class$sqlj$runtime$profile$Profile).isAssignableFrom(cl = loader.loadClass(profileName))) {
                try {
                    result = (Profile)cl.newInstance();
                    result.setLoader(loader);
                }
                catch (Exception ex) {
                    LOCATION.catching((Throwable)ex);
                    throw new ClassNotFoundException("unable to instantiate profile " + profileName);
                }
            }
            if ((class$sqlj$runtime$profile$SerializedProfile == null ? (class$sqlj$runtime$profile$SerializedProfile = Profile.class$("sqlj.runtime.profile.SerializedProfile")) : class$sqlj$runtime$profile$SerializedProfile).isAssignableFrom(cl)) {
                SerializedProfile sp;
                try {
                    sp = (SerializedProfile)cl.newInstance();
                }
                catch (Exception ex) {
                    String msg = "unable to instantiate serialized profile " + profileName;
                    LOCATION.traceThrowableT(500, msg, (Throwable)ex);
                    throw new ClassNotFoundException(msg);
                }
                result = Profile.instantiate(loader, sp.getProfileAsStream());
            } else {
                throw new ClassNotFoundException(profileName + " is not a valid profile");
            }
        }
        return result;
    }

    public static Profile instantiate(Loader loader, InputStream serProfile) throws ClassNotFoundException, IOException {
        if (loader == null) {
            loader = new DefaultLoader(null);
        }
        Profile result = null;
        try {
            ObjectInputStreamWithLoader oins = new ObjectInputStreamWithLoader(serProfile, loader);
            result = (Profile)oins.readObject();
            oins.close();
        }
        catch (IOException ex) {
            serProfile.close();
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            serProfile.close();
            throw ex;
        }
        result.setLoader(loader);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private Loader m_loader;

        public ObjectInputStreamWithLoader(InputStream in, Loader loader) throws IOException, StreamCorruptedException {
            super(in);
            this.m_loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String classname = classDesc.getName();
            if (classname.startsWith("[")) {
                return super.resolveClass(classDesc);
            }
            return this.m_loader.loadClass(classname);
        }
    }
}

