/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.templates.Snippet;
import com.tssap.selena.cmf.internal.templates.SnippetContext;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateCategory;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateEngine;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.ITemplateModel;
import com.tssap.selena.cmf.templates.ITemplateProject;
import com.tssap.selena.cmf.templates.ITemplateRegistry;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public final class Templates {
    public static final String NATURE_ID = "com.tssap.selena.cmf.TemplateNature";

    private Templates() {
    }

    public static ITemplateModel getModel() {
        return CodePlugin.getInstance().getTemplateModel();
    }

    public static ITemplateProject[] getProjects() {
        return Templates.getModel().getProjects();
    }

    public static ITemplateProject getProject(IProject project) {
        return Templates.getModel().getProject(project);
    }

    public static ITemplateProject getLocalProject() {
        return Templates.getModel().getProject(null);
    }

    public static boolean hasNature(IProject project) {
        try {
            return project.hasNature(NATURE_ID);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ITemplate findTemplate(IFile file) {
        IContainer parent = file.getParent();
        ITemplateProject project = Templates.getProject(file.getProject());
        if (project == null) {
            return null;
        }
        ITemplateManager[] managers = project.getManagers();
        int i = 0;
        while (i < managers.length) {
            ITemplateCategory[] categories = managers[i].getCategories();
            int j = 0;
            while (j < categories.length) {
                ITemplate template = ((WorkspaceTemplateCategory)categories[j]).findTemplate(file);
                if (template != null) {
                    return template;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static ITemplateRegistry getTemplateRegistry() {
        return CodePlugin.getInstance().getTemplateRegistry();
    }

    public static ITemplateExtension getExtension(String id) {
        return Templates.getTemplateRegistry().getExtension(id);
    }

    public static ITemplateExtension[] getExtensions() {
        return Templates.getTemplateRegistry().getExtensions();
    }

    public static ITemplateEngine getTemplateEngine() {
        return CodePlugin.getInstance().getTemplateEngine();
    }

    public static ISnippet createSnippet(String input) {
        return new Snippet(input);
    }

    public static ISnippetContext createSnippetContext() {
        return new SnippetContext();
    }

    public static ISnippetContext createSnippetContext(ITemplate template) throws CoreException {
        SnippetContext context = new SnippetContext();
        ITemplateSource source = template.getSource();
        ITemplateVariable[] variables = source.getVariables();
        int i = 0;
        while (i < variables.length) {
            ITemplateVariable property = variables[i];
            String name = property.getName();
            Object value = template.getVariableValue(property);
            context.addVariable(name, value);
            ++i;
        }
        return context;
    }
}

