/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.patterns;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.PluginConstants;
import com.tssap.selena.cmf.internal.patterns.PatternPreference;
import com.tssap.selena.cmf.internal.patterns.PatternProjectPreferences;
import com.tssap.selena.cmf.patterns.DefaultPatternRegionFactory;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternCategory;
import com.tssap.selena.cmf.patterns.IPatternExtension;
import com.tssap.selena.cmf.patterns.IPatternManager;
import com.tssap.selena.cmf.patterns.IPatternModel;
import com.tssap.selena.cmf.patterns.IPatternPreference;
import com.tssap.selena.cmf.patterns.IPatternProject;
import com.tssap.selena.cmf.patterns.IPatternProjectPreferences;
import com.tssap.selena.cmf.patterns.IPatternRegion;
import com.tssap.selena.cmf.patterns.IPatternRegionFactory;
import com.tssap.selena.cmf.patterns.IPatternRegistry;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;

public final class Patterns
implements PluginConstants {
    public static final String NATURE_ID = "com.tssap.selena.cmf.PatternNature";
    public static final String BUILDER_ID = "com.tssap.selena.cmf.PatternBuilder";
    public static final String FORCE_BUILD = "force";
    public static final String PRESERVE_EXISTING_PATTERNS = "preserveExisiting";
    private static final String REGION_EXT_POINT = "patternRegion";
    private static final String IMPLEMENTATION_CFG = "factory";
    private static final String CLASS_NAME = "class";
    private static IPatternProjectPreferences defaultPreferences;
    private static IPatternRegionFactory myFactory;

    private Patterns() {
    }

    public static IPatternModel getModel() {
        return CodePlugin.getInstance().getPatternModel();
    }

    public static IPatternProject[] getProjects() {
        return Patterns.getModel().getProjects();
    }

    public static IPatternProject getProject(IProject project) {
        return Patterns.getModel().getProject(project);
    }

    public static boolean isPatternProject(IProject project) {
        return Patterns.hasNature(project);
    }

    public static IPatternRegistry getRegistry() {
        return CodePlugin.getInstance().getPatternRegistry();
    }

    public static IPatternCategory[] getCategories() {
        return Patterns.getRegistry().getCategories();
    }

    public static IPatternExtension[] getExtensions() {
        return Patterns.getRegistry().getExtensions();
    }

    public static IPatternProjectPreferences getDefaultProjectPreferences() {
        if (defaultPreferences == null) {
            IPatternExtension[] patterns = Patterns.getRegistry().getExtensions();
            IPatternPreference[] preferences = new IPatternPreference[patterns.length];
            int i = 0;
            while (i < patterns.length) {
                preferences[i] = new PatternPreference(patterns[i], patterns[i].getRecognizer(), true);
                ++i;
            }
            defaultPreferences = new PatternProjectPreferences();
            defaultPreferences.setPreferences(preferences);
            defaultPreferences.setRegion(Patterns.newPatternRegion(null));
        }
        return defaultPreferences;
    }

    public static IPattern createEmptyPattern(IPatternProject patternProject, String extensionID) {
        IPatternManager[] managers = patternProject.getManagers();
        int i = 0;
        while (i < managers.length) {
            if (extensionID.equals(managers[i].getExtension().getId())) {
                IPattern aPattern = managers[i].getExtension().createPattern(managers[i]);
                return aPattern;
            }
            ++i;
        }
        throw new IllegalArgumentException("Couldn't find PatternManager for extension '" + extensionID + "' in project " + patternProject.getProject());
    }

    private static boolean hasNature(IProject project) {
        try {
            return project.hasNature(NATURE_ID);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void rebuild(IProject project, IProgressMonitor monitor) throws CoreException {
        Patterns.rebuild(project, Collections.singletonMap(FORCE_BUILD, Boolean.TRUE), monitor);
    }

    public static void rebuild(IProject project, Map builderArgs, IProgressMonitor monitor) throws CoreException {
        project.build(6, BUILDER_ID, builderArgs, monitor);
    }

    public static IPatternRegion newPatternRegion(IPatternProject project) {
        return Patterns.newPatternRegion(project, null);
    }

    public static IPatternRegion newPatternRegion(IPatternProject project, IPatternRegion defaults) {
        IPatternRegionFactory factory = Patterns.getPatternRegionFactory();
        return factory.getPatternRegion(project, defaults);
    }

    private static IPatternRegionFactory getPatternRegionFactory() {
        if (myFactory == null) {
            IExtensionPoint extensionPoint = CodePlugin.getInstance().getDescriptor().getExtensionPoint(REGION_EXT_POINT);
            if (extensionPoint == null) {
                throw new IllegalArgumentException("Could not load pattern region extension point");
            }
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions != null && extensions.length >= 1) {
                IExtension extension = extensions[0];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                int i = 0;
                while (i < configurationElements.length) {
                    if (IMPLEMENTATION_CFG.equals(configurationElements[i].getName())) {
                        try {
                            myFactory = (IPatternRegionFactory)configurationElements[i].createExecutableExtension(CLASS_NAME);
                            break;
                        }
                        catch (Throwable cantLoadPlatform) {
                            cantLoadPlatform.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        }
        if (myFactory == null) {
            myFactory = new DefaultPatternRegionFactory();
        }
        return myFactory;
    }
}

