/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.templates.TemplateProject;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateManager;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class WorkspaceTemplateProject
extends TemplateProject {
    private static final String ROOT_FOLDER = ".templates";
    private IFolder folder;
    private IProject project;
    private ITemplateManager[] managers;

    public WorkspaceTemplateProject(IProject project) {
        this.project = project;
        this.getManagers();
    }

    public String toString() {
        return "<TemplateProject name=" + this.getName() + " />";
    }

    public boolean isEmpty() {
        try {
            return !this.getTemplateContainer().exists();
        }
        catch (Exception e) {
            return true;
        }
    }

    public String getName() {
        return this.project.getName();
    }

    public IProject getProject() {
        return this.project;
    }

    public IContainer getTemplateContainer() throws CoreException {
        if (this.folder == null) {
            this.folder = this.project.getFolder(ROOT_FOLDER);
        }
        return this.folder;
    }

    public IContainer createTemplateContainer() throws CoreException {
        this.getTemplateContainer();
        if (!this.folder.exists()) {
            this.folder.create(false, true, null);
        }
        return this.folder;
    }

    public ITemplateManager[] getManagers() {
        if (this.managers == null) {
            ITemplateExtension[] exts = CodePlugin.getInstance().getTemplateRegistry().getExtensions();
            this.managers = new ITemplateManager[exts.length];
            int i = 0;
            while (i < exts.length) {
                this.managers[i] = new WorkspaceTemplateManager(exts[i], this);
                ++i;
            }
        }
        return this.managers;
    }
}

