/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.templates.Messages;
import com.tssap.selena.cmf.internal.templates.TemplateManager;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplate;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateCategory;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateProject;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateProject;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceTemplateManager
extends TemplateManager {
    private static final String DEFAULT_CATEGORY = Messages.getString("Misc_1");
    protected WorkspaceTemplateProject project;
    protected IFolder folder;

    public WorkspaceTemplateManager(ITemplateExtension extension, WorkspaceTemplateProject project) {
        super(extension);
        this.project = project;
        this.initTemplates();
    }

    public ITemplateProject getProject() {
        return this.project;
    }

    private void initTemplates() {
        try {
            IFolder folder = this.getTemplateFolder();
            if (folder != null && folder.exists()) {
                IResource[] members = folder.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member instanceof IFolder) {
                        this.addTemplateCategory((IFolder)member);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            CodePlugin.error("cannot create template", e);
        }
    }

    private void addTemplateCategory(IFolder folder) throws CoreException {
        WorkspaceTemplateCategory category = this.createTemplateCategory(folder);
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member instanceof IFile) {
                this.addTemplateFile(category, member);
            }
            ++i;
        }
    }

    private void addTemplateFile(WorkspaceTemplateCategory category, IResource resource) throws CoreException {
        try {
            String ext;
            if (resource instanceof IFile && (ext = resource.getFileExtension()) != null && ext.equals("template")) {
                ITemplate template = this.loadTemplate(category, (IFile)resource);
                category.addTemplate(template);
            }
        }
        catch (CoreException e) {
            CodePlugin.error("cannot create template", e);
        }
    }

    ITemplate loadTemplate(WorkspaceTemplateCategory category, IFile file) throws CoreException {
        try {
            ITemplateSource source = this.extension.loadSource(file.getContents(true));
            WorkspaceTemplate template = new WorkspaceTemplate(category, file);
            template.setSource(source);
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public IFolder getTemplateFolder() throws CoreException {
        IContainer parent;
        if (this.folder == null && (parent = this.project.getTemplateContainer()).exists()) {
            this.folder = parent.getFolder((IPath)new Path(this.extension.getStore()));
        }
        return this.folder;
    }

    private IFolder createTemplateFolder(IProgressMonitor monitor) throws CoreException {
        if (this.folder == null) {
            IContainer container = this.project.createTemplateContainer();
            this.folder = container.getFolder((IPath)new Path(this.extension.getStore()));
        }
        if (!this.folder.exists()) {
            this.folder.create(true, true, monitor);
        }
        return this.folder;
    }

    void categoryAdded(IFolder folder) throws CoreException {
        CodePlugin.debug("categoryAdded: folder={0}", folder.getName());
        WorkspaceTemplateCategory category = this.findCategory((IContainer)folder);
        if (category == null) {
            CodePlugin.debug("adding category: folder={0}", folder.getName());
            category = this.createTemplateCategory(folder);
            this.addCategory(category);
        }
    }

    void categoryRemoved(IFolder folder) throws CoreException {
        CodePlugin.debug("categoryRemoved: folder={0}", folder.getName());
        WorkspaceTemplateCategory category = this.findCategory((IContainer)folder);
        if (category != null) {
            CodePlugin.debug("removing category: folder={0}", folder.getName());
            this.removeCategory(category);
        }
    }

    WorkspaceTemplateCategory findCategory(IContainer container) {
        ITemplateCategory[] categories = this.getCategories();
        int i = 0;
        while (i < categories.length) {
            WorkspaceTemplateCategory category = (WorkspaceTemplateCategory)categories[i];
            if (container.equals((Object)category.getFolder())) {
                return category;
            }
            ++i;
        }
        return (WorkspaceTemplateCategory)this.getDefaultCategory();
    }

    public ITemplateCategory getDefaultCategory() {
        try {
            return this.createTemplateCategory(DEFAULT_CATEGORY);
        }
        catch (Exception e) {
            CodePlugin.warn("Error creating template category", e);
            return null;
        }
    }

    public ITemplateCategory createCategory(String name, IProgressMonitor monitor) throws CoreException {
        return this.createTemplateCategory(name);
    }

    WorkspaceTemplateCategory createTemplateCategory(String name) throws CoreException {
        IFolder folder = this.createTemplateFolder(null);
        if (!(folder = folder.getFolder((IPath)new Path(name))).exists()) {
            folder.create(true, true, null);
        }
        return this.createTemplateCategory(folder);
    }

    WorkspaceTemplateCategory createTemplateCategory(IFolder folder) throws CoreException {
        WorkspaceTemplateCategory category = this.getTemplateCategory(folder.getName());
        if (category == null) {
            category = new WorkspaceTemplateCategory(this, folder);
            this.addCategory(category);
        }
        return category;
    }

    WorkspaceTemplateCategory getTemplateCategory(String name) {
        ITemplateCategory[] categories = this.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (name.equals(categories[i].getName())) {
                return (WorkspaceTemplateCategory)categories[i];
            }
            ++i;
        }
        return null;
    }
}

