/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.templates.TemplateCategory;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplate;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateManager;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceTemplateCategory
extends TemplateCategory {
    private IFolder folder;
    private WorkspaceTemplateManager manager;

    public WorkspaceTemplateCategory(WorkspaceTemplateManager manager, IFolder folder) {
        super(folder.getName());
        this.folder = folder;
        this.manager = manager;
    }

    public ITemplateManager getManager() {
        return this.manager;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public ITemplate createTemplate(String name, ITemplateSource source, IProgressMonitor monitor) throws CoreException {
        try {
            ITemplateExtension extension = this.manager.getExtension();
            IFolder folder = this.getFolder();
            Path path = new Path(name + ".template");
            IFile file = folder.getFile((IPath)path);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            extension.saveSource(out, source);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            if (file.exists()) {
                file.setContents((InputStream)in, false, true, monitor);
            } else {
                file.create((InputStream)in, false, monitor);
            }
            WorkspaceTemplate template = (WorkspaceTemplate)this.findTemplate(name);
            if (template == null) {
                template = new WorkspaceTemplate(this, file);
                template.setSource(source);
                this.addTemplate(template);
            } else {
                template.setSource(source);
            }
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public void rename(String name, IProgressMonitor monitor) throws CoreException {
        if (this.folder == null) {
            throw new IllegalStateException();
        }
        IContainer parent = this.folder.getParent();
        IPath dest = parent.getFullPath().append(name);
        this.folder.move(dest, false, true, monitor);
        this.name = name;
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        if (this.folder == null) {
            throw new IllegalStateException();
        }
        if (this.folder.exists()) {
            this.folder.delete(true, true, monitor);
            if (this.manager != null) {
                this.manager.removeCategory(this);
            }
        }
    }

    void templateAdded(IFile file) throws CoreException {
        CodePlugin.debug("templateAdded: file={0}", file.getName());
        ITemplate template = this.findTemplate(file);
        if (template == null) {
            template = this.manager.loadTemplate(this, file);
            this.addTemplate(template);
        }
    }

    void templateRemoved(IFile file) throws CoreException {
        CodePlugin.debug("templateRemoved: file={0}", file.getName());
        ITemplate template = this.findTemplate(file);
        if (template != null) {
            this.removeTemplate(template);
        }
    }

    public ITemplate findTemplate(IFile file) {
        ITemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            WorkspaceTemplate template = (WorkspaceTemplate)templates[i];
            if (file.equals((Object)template.getFile())) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public ITemplate findTemplate(IPath pth) {
        String path = pth.toString();
        ITemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            WorkspaceTemplate template = (WorkspaceTemplate)templates[i];
            if (path.equals(template.getLocation())) {
                return template;
            }
            ++i;
        }
        return null;
    }
}

