/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.Template;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceTemplate
extends Template {
    private WorkspaceTemplateCategory category;
    private IFile file;
    private String name;
    private String path;

    public WorkspaceTemplate(WorkspaceTemplateCategory category, IFile file) {
        this.category = category;
        this.file = file;
        this.path = file.getLocation().toString();
        this.name = CodeToolkit.getFileStem(file.getName());
    }

    public ITemplateCategory getCategory() {
        return this.category;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof WorkspaceTemplate && this.equals((WorkspaceTemplate)o);
    }

    private boolean equals(WorkspaceTemplate that) {
        return this.file.equals((Object)that.file);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.path;
    }

    public IFile getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void save(ITemplateSource source, IProgressMonitor monitor) throws CoreException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getExtension().saveSource(out, source);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            if (this.file.exists()) {
                this.file.setContents((InputStream)in, false, true, monitor);
            } else {
                this.file.create((InputStream)in, false, monitor);
            }
            this.setSource(source);
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public void rename(String name, IProgressMonitor monitor) throws CoreException {
        if (this.file == null) {
            throw new IllegalStateException();
        }
        IContainer parent = this.file.getParent();
        IPath dest = parent.getFullPath().append(name + ".template");
        this.file.move(dest, false, true, monitor);
        this.name = name;
        this.file = parent.getFile(dest);
        this.path = dest.toString();
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        if (this.file == null) {
            throw new IllegalStateException();
        }
        if (this.file.exists()) {
            this.file.delete(true, true, monitor);
            if (this.category != null) {
                this.category.removeTemplate(this);
            }
        }
    }
}

