/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ITemplateConstants;
import com.tssap.selena.cmf.internal.templates.TemplateManager;
import com.tssap.selena.cmf.internal.templates.TemplateModel;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateCategory;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateManager;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateProject;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.Templates;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class WorkspaceDeltaVisitor
implements IResourceDeltaVisitor,
ITemplateConstants {
    private WorkspaceTemplateProject currentProject;
    private WorkspaceTemplateManager currentManager;
    private IContainer currentContainer;
    private WorkspaceTemplateCategory currentCategory;

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                this.currentProject = null;
                this.currentManager = null;
                this.currentContainer = null;
                this.currentCategory = null;
                return true;
            }
            case 4: {
                return this.visitProject(delta, (IProject)resource);
            }
            case 2: {
                return this.visitFolder(delta, (IFolder)resource);
            }
            case 1: {
                return this.visitFile(delta, (IFile)resource);
            }
        }
        return false;
    }

    private boolean visitProject(IResourceDelta delta, IProject project) throws CoreException {
        if (delta.getKind() == 2) {
            return false;
        }
        if (project.isOpen() && project.hasNature("com.tssap.selena.cmf.TemplateNature")) {
            this.currentProject = (WorkspaceTemplateProject)Templates.getProject(project);
            if (this.currentProject != null) {
                this.currentContainer = this.currentProject.getTemplateContainer();
                return this.currentContainer != null && this.currentContainer.exists();
            }
        }
        return false;
    }

    private boolean visitFolder(IResourceDelta delta, IFolder folder) throws CoreException {
        if (folder.equals((Object)this.currentContainer)) {
            return true;
        }
        IContainer parent = folder.getParent();
        if (parent.equals((Object)this.currentContainer)) {
            this.currentManager = this.getTemplateManager(folder);
            this.currentCategory = null;
            return this.currentManager != null;
        }
        if (this.currentManager != null && parent.equals((Object)this.currentManager.getTemplateFolder())) {
            return this.visitCategory(delta, folder);
        }
        return false;
    }

    private boolean visitCategory(IResourceDelta delta, IFolder folder) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                this.currentCategory = this.currentManager.getTemplateCategory(folder.getName());
                this.currentManager.categoryAdded(folder);
                return true;
            }
            case 2: {
                this.currentManager.categoryRemoved(folder);
                return false;
            }
            case 4: {
                this.currentCategory = this.currentManager.getTemplateCategory(folder.getName());
                return true;
            }
        }
        return false;
    }

    private WorkspaceTemplateManager getTemplateManager(IFolder folder) throws CoreException {
        ITemplateManager[] managers = this.currentProject.getManagers();
        int i = 0;
        while (i < managers.length) {
            TemplateManager manager = (TemplateManager)managers[i];
            if (manager instanceof WorkspaceTemplateManager && folder.equals((Object)((WorkspaceTemplateManager)manager).getTemplateFolder())) {
                return (WorkspaceTemplateManager)manager;
            }
            ++i;
        }
        return null;
    }

    private boolean visitFile(IResourceDelta delta, IFile file) throws CoreException {
        if (this.currentCategory == null) {
            return false;
        }
        String ext = file.getFileExtension();
        if (ext != null && ext.equals("template")) {
            switch (delta.getKind()) {
                case 1: {
                    if (this.currentCategory.findTemplate(file.getFullPath()) != null) {
                        TemplateModel.projectChanged(this.currentProject);
                        break;
                    }
                    this.currentCategory.templateAdded(file);
                    break;
                }
                case 2: {
                    IPath path;
                    if ((0x2000 & delta.getFlags()) != 0 && this.currentCategory.findTemplate(path = delta.getMovedToPath()) != null) {
                        TemplateModel.projectChanged(this.currentProject);
                        break;
                    }
                    this.currentCategory.templateRemoved(file);
                    break;
                }
            }
        }
        return false;
    }
}

