/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.TemplateContext;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.TemplateException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public abstract class TypeTemplateContext
extends TemplateContext {
    private IType[] targets;

    public void init(ITemplate template, Object[] selection) throws CoreException {
        super.init(template, selection);
        this.targets = null;
    }

    public void apply(IProgressMonitor monitor) throws CoreException {
        String error = this.isValid();
        if (error != null) {
            throw new TemplateException(error);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IType[] targets = this.getTargets();
        try {
            monitor.beginTask(this.template.getName(), targets.length);
            int i = 0;
            while (i < targets.length) {
                this.work(targets[i]);
                monitor.worked(1);
                ++i;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected abstract void work(IType var1) throws CoreException;

    protected IType[] getTargets() throws CoreException {
        if (this.targets == null) {
            ArrayList<Object> types = new ArrayList<Object>();
            int i = 0;
            while (i < this.selection.length) {
                Object element = this.selection[i];
                if (element instanceof IType) {
                    types.add(element);
                } else if (element instanceof ICompilationUnit) {
                    ICompilationUnit unit = (ICompilationUnit)element;
                    types.add(unit.getTypes()[0]);
                } else if (element instanceof IJavaProject) {
                    this.addTargets(types, (IJavaProject)element);
                } else if (element instanceof IPackageFragment) {
                    this.addTargets(types, (IPackageFragment)element);
                } else {
                    throw new TemplateException("illegal selection element: " + element);
                }
                ++i;
            }
            this.targets = types.toArray(new IType[types.size()]);
        }
        return this.targets;
    }

    private void addTargets(ArrayList types, IJavaProject project) throws CoreException {
        IPackageFragment[] fragments = project.getPackageFragments();
        int i = 0;
        while (i < fragments.length) {
            this.addTargets(types, fragments[i]);
            ++i;
        }
    }

    private void addTargets(ArrayList types, IPackageFragment fragment) throws CoreException {
        ICompilationUnit[] units = fragment.getCompilationUnits();
        int i = 0;
        while (i < units.length) {
            ICompilationUnit unit = units[i];
            types.add(unit.getTypes()[0]);
            ++i;
        }
    }
}

