/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateSerializer;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TemplateWriter {
    private static DocumentBuilder builder;
    protected OutputStream out;
    protected ITemplateExtension extension;
    protected Document document;
    protected Element rootElement;

    public static DocumentBuilder getDocumentBuilder() {
        if (builder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException();
            }
        }
        return builder;
    }

    public static Document createDocument() {
        return TemplateWriter.getDocumentBuilder().newDocument();
    }

    public TemplateWriter(OutputStream out, ITemplateExtension extension) {
        this.out = out;
        this.extension = extension;
    }

    public void writeSource(ITemplateSource source) throws IOException {
        this.document = TemplateWriter.createDocument();
        this.rootElement = this.createRootElement();
        this.addElements(source);
        try {
            TemplateSerializer serializer = new TemplateSerializer(this.out);
            serializer.serialize(this.document);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.out.close();
            throw throwable;
        }
        this.out.close();
    }

    protected void addElements(ITemplateSource source) {
        Class contextClass;
        String helpContextId;
        String description = source.getDescription();
        if (description != null && description.length() > 0) {
            this.addDataElement("description", description);
        }
        if ((helpContextId = source.getHelpContextId()) != null && helpContextId.length() > 0) {
            this.addTextElement("help", helpContextId);
        }
        if ((contextClass = source.getContextClass()) != null) {
            IPluginDescriptor contextPlugin = source.getContextPlugin();
            Element element = this.createElement("context");
            element.setAttribute("class", contextClass.getName());
            if (contextPlugin != null) {
                element.setAttribute("plugin", contextPlugin.getUniqueIdentifier());
            }
            this.addElement(element);
        }
        this.addVariables(source);
    }

    protected Element createRootElement() {
        Element element = this.document.createElement("template");
        this.document.appendChild(element);
        return element;
    }

    protected void addElement(Element element) {
        this.rootElement.appendChild(element);
    }

    protected void addTextElement(String tag, String data) {
        this.addElement(this.createTextElement(tag, data));
    }

    protected void addTextElement(String tag, ISnippet data) {
        this.addTextElement(tag, data.getInput());
    }

    protected void addDataElement(String tag, String data) {
        this.addElement(this.createDataElement(tag, data));
    }

    protected void addDataElement(String tag, ISnippet data) {
        this.addDataElement(tag, data.getInput());
    }

    protected void addVariables(ITemplateSource source) {
        ITemplateVariable[] variables = source.getVariables();
        int i = 0;
        while (i < variables.length) {
            this.addProperty(variables[i]);
            ++i;
        }
    }

    protected void addProperty(ITemplateVariable property) {
        String params;
        Element element = this.createElement("property");
        element.setAttribute("name", property.getName());
        element.setAttribute("type", property.getType());
        element.setAttribute("label", property.getLabel());
        String value = property.getValue();
        if (value != null && value.length() > 0) {
            element.setAttribute("value", value);
        }
        if ((params = this.join(property.getParams())) != null && params.length() > 0) {
            element.setAttribute("params", params);
        }
        this.addElement(element);
    }

    private String join(String[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            sbuf.append(elements[i]).append(',');
            ++i;
        }
        int length = sbuf.length();
        if (length > 0) {
            sbuf.setLength(length - 1);
        }
        return sbuf.toString();
    }

    protected Element createElement(String name) {
        return this.document.createElement(name);
    }

    protected Element createTextElement(String name, String value) {
        Element element = this.document.createElement(name);
        element.appendChild(this.document.createTextNode(value));
        return element;
    }

    protected Element createTextElement(String name, ISnippet value) {
        return this.createTextElement(name, value.getInput());
    }

    protected Element createDataElement(String name, String value) {
        Element element = this.document.createElement(name);
        element.appendChild(this.document.createCDATASection(value));
        return element;
    }

    protected Element createDataElement(String name, ISnippet value) {
        return this.createDataElement(name, value.getInput());
    }

    protected void addDataElements(String tag, String[] data) {
        int i = 0;
        while (i < data.length) {
            this.addDataElement(tag, data[i]);
            ++i;
        }
    }

    protected void addTextElements(String tag, String[] data) {
        int i = 0;
        while (i < data.length) {
            this.addTextElement(tag, data[i]);
            ++i;
        }
    }

    protected void addTextElements(String tag, ISnippet[] data) {
        int i = 0;
        while (i < data.length) {
            this.addTextElement(tag, data[i]);
            ++i;
        }
    }

    protected void addSourceElements(String tag, SourceElement[] data) {
        int i = 0;
        while (i < data.length) {
            this.addSourceElement(tag, data[i]);
            ++i;
        }
    }

    protected void addSourceElement(String tag, SourceElement data) {
        Element element = this.createDataElement(tag, data.getContents().getInput());
        element.setAttribute("name", data.getName().getInput());
        this.addElement(element);
    }
}

