/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.IConstants;
import com.tssap.selena.cmf.internal.templates.SnippetContext;
import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateVariable;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;

public abstract class TemplateSource
implements IConstants,
ITemplateSource {
    private boolean valid;
    private ITemplateVariable[] variables;
    private String description;
    private Class contextClass;
    private IPluginDescriptor contextPlugin;
    private String helpContextId;

    public TemplateSource() {
        this.valid = true;
        this.variables = IConstants.EMPTY_VARIABLES;
        this.description = "";
    }

    public TemplateSource(TemplateSource source) {
        this.valid = source.isValid();
        this.variables = TemplateSource.copy(source.getVariables());
        this.description = source.description;
        this.contextClass = source.contextClass;
        this.contextPlugin = source.contextPlugin;
        this.helpContextId = source.helpContextId;
    }

    static String[] copy(String[] orig) {
        String[] copy = new String[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    static ISnippet[] copy(ISnippet[] orig) {
        ISnippet[] copy = new ISnippet[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    static ITemplateVariable[] copy(ITemplateVariable[] orig) {
        ITemplateVariable[] copy = new ITemplateVariable[orig.length];
        int i = 0;
        while (i < orig.length) {
            copy[i] = new TemplateVariable(orig[i]);
            ++i;
        }
        return copy;
    }

    static SourceElement[] copy(SourceElement[] orig) {
        SourceElement[] copy = new SourceElement[orig.length];
        int i = 0;
        while (i < orig.length) {
            copy[i] = new SourceElement(orig[i].getName(), orig[i].getContents());
            ++i;
        }
        return copy;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public IPluginDescriptor getContextPlugin() {
        return this.contextPlugin;
    }

    public ITemplateVariable[] getVariables() {
        return this.variables;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelpContextId() {
        return this.helpContextId;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void validate() {
        ISnippetContext context = this.createSnippetContext();
        try {
            this.validate(context);
            this.valid = true;
        }
        catch (CoreException e) {
            this.valid = false;
        }
    }

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public void setContextPlugin(IPluginDescriptor contextPlugin) {
        this.contextPlugin = contextPlugin;
    }

    public void setVariables(ITemplateVariable[] variables) {
        this.variables = variables;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHelpContextId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    protected ISnippetContext createSnippetContext() {
        SnippetContext context = new SnippetContext();
        context.addVariable("className", "");
        context.addVariable("packageName", "");
        ITemplateVariable[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length) {
            ITemplateVariable property = variables[i];
            String name = property.getName();
            String value = property.getValue();
            context.addVariable(name, value);
            ++i;
        }
        return context;
    }

    protected void validate(ISnippetContext context) throws CoreException {
    }

    protected void validateSnippets(ISnippetContext context, ISnippet[] snippets) throws CoreException {
        int i = 0;
        while (i < snippets.length) {
            snippets[i].render(context);
            ++i;
        }
    }

    protected void validateSnippets(ISnippetContext context, SourceElement[] elements) throws CoreException {
        int i = 0;
        while (i < elements.length) {
            elements[i].getContents().render(context);
            ++i;
        }
    }
}

