/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateSerializer {
    private PrintWriter printer;

    public TemplateSerializer(OutputStream out) {
        try {
            this.printer = new PrintWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            CodePlugin.warn(ex.getMessage(), ex);
            this.printer = new PrintWriter(out);
        }
    }

    public void serialize(Document document) throws IOException {
        this.printer.println("<?xml version='1.0'?>");
        this.printer.println("<template>");
        Element element = document.getDocumentElement();
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node child = children.item(i);
            String name = child.getNodeName();
            switch (child.getNodeType()) {
                case 1: {
                    this.dumpElement((Element)child);
                    break;
                }
                default: {
                    throw new IOException("bogus node: " + child);
                }
            }
            ++i;
        }
        this.printer.println("</template>");
        this.printer.close();
    }

    protected void dumpElement(Element element) throws IOException {
        Node child = element.getFirstChild();
        if (child == null) {
            this.dumpEmptyElement(element);
            return;
        }
        switch (child.getNodeType()) {
            case 3: {
                this.dumpTextElement(element, child.getNodeValue());
                break;
            }
            case 4: {
                this.dumpDataElement(element, child.getNodeValue());
                break;
            }
            default: {
                throw new IOException("bogus element: " + element);
            }
        }
    }

    private void dumpEmptyElement(Element element) throws IOException {
        this.emptyTag(element.getNodeName(), element.getAttributes());
    }

    private void dumpTextElement(Element element, String contents) throws IOException {
        String name = element.getNodeName();
        this.openTag(name, element.getAttributes());
        this.printer.print(contents);
        this.closeTag(name);
    }

    private void dumpDataElement(Element element, String contents) throws IOException {
        String name = element.getNodeName();
        this.openTag(name, element.getAttributes());
        this.printer.println("<![CDATA[");
        this.printer.println(contents);
        this.printer.println("]]>");
        this.closeTag(name);
    }

    private void openTag(String name, NamedNodeMap attrs) throws IOException {
        this.printer.print('<');
        this.printer.print(name);
        if (attrs != null) {
            this.attributes(attrs);
        }
        this.printer.print('>');
    }

    private void closeTag(String name) throws IOException {
        this.printer.print("</");
        this.printer.print(name);
        this.printer.println('>');
    }

    private void emptyTag(String name, NamedNodeMap attrs) throws IOException {
        this.printer.print('<');
        this.printer.print(name);
        if (attrs != null) {
            this.attributes(attrs);
        }
        this.printer.println("/>");
    }

    private void attributes(NamedNodeMap attrs) throws IOException {
        int i = 0;
        while (i < attrs.getLength()) {
            this.printer.print("\n\t");
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String value = attr.getNodeValue();
            this.printer.print(name);
            this.printer.print("=\"");
            this.printer.print(value);
            this.printer.print('\"');
            ++i;
        }
    }
}

