/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.IConstants;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateVariable;
import com.tssap.selena.cmf.internal.templates.TemplateWriter;
import com.tssap.selena.cmf.templates.ITemplateContext;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class TemplateReader
implements IConstants {
    protected InputStream input;
    protected ITemplateExtension extension;
    protected ArrayList variables;
    protected String description;
    protected String helpContextId;
    protected Class contextClass;
    protected IPluginDescriptor contextPlugin;

    public static DocumentBuilder createParser() {
        return TemplateWriter.getDocumentBuilder();
    }

    public TemplateReader(InputStream input, ITemplateExtension extension) {
        this.input = input;
        this.extension = extension;
        this.variables = new ArrayList();
        this.description = "";
    }

    protected ITemplateVariable[] getVariables() {
        return this.variables.toArray(new ITemplateVariable[this.variables.size()]);
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public IPluginDescriptor getContextPlugin() {
        return this.contextPlugin;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelpContextId() {
        return this.helpContextId;
    }

    protected abstract TemplateSource createSource();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITemplateSource readSource() throws IOException {
        TemplateSource templateSource;
        try {
            try {
                Document document = TemplateReader.createParser().parse(this.input);
                this.parse(document);
                TemplateSource source = this.createSource();
                source.setVariables(this.getVariables());
                source.setDescription(this.getDescription());
                source.setContextClass(this.getContextClass());
                source.setContextPlugin(this.getContextPlugin());
                source.setHelpContextId(this.getHelpContextId());
                templateSource = source;
                Object var5_5 = null;
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.input.close();
            throw throwable;
        }
        this.input.close();
        return templateSource;
    }

    public void parse(Document document) throws IOException {
        Element root = document.getDocumentElement();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    this.addElement((Element)child);
                }
            }
            ++i;
        }
    }

    protected void addElement(Element element) throws IOException {
        String name = element.getNodeName();
        if ("context".equals(name)) {
            this.setContext(element);
        } else if ("property".equals(name)) {
            this.addVariable(element);
        } else if ("description".equals(name)) {
            this.description = this.getContents(element);
            if (this.description == null) {
                this.description = "";
            }
        } else if ("help".equals(name)) {
            this.helpContextId = this.getContents(element);
        } else {
            throw new IOException("unknown tag " + name);
        }
    }

    protected void setContext(Element element) throws IOException {
        String className = element.getAttribute("class");
        String pluginName = element.getAttribute("plugin");
        if (className == null || className.length() == 0) {
            throw new IOException("no context class specified");
        }
        if (pluginName != null && pluginName.length() > 0) {
            Plugin plugin = Platform.getPlugin((String)pluginName);
            if (plugin == null) {
                throw new IOException("unknown context plugin " + pluginName);
            }
            this.contextPlugin = plugin.getDescriptor();
        } else {
            this.contextPlugin = this.extension.getConfigurationElement().getDeclaringExtension().getDeclaringPluginDescriptor();
        }
        try {
            this.contextClass = this.contextPlugin.getPluginClassLoader().loadClass(className);
            Object instance = this.contextClass.newInstance();
            if (!(instance instanceof ITemplateContext)) {
                throw new IOException("illegal context class " + className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException("unknown context class " + className);
        }
        catch (Exception e) {
            throw new IOException("illegal context class " + className);
        }
    }

    protected void addVariable(Element element) throws IOException {
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        String label = element.getAttribute("label");
        String value = element.getAttribute("value");
        String params = element.getAttribute("params");
        if (name.length() == 0 || type.length() == 0) {
            throw new IOException("invalid property markup " + element);
        }
        if (label.length() == 0) {
            label = name;
        }
        this.variables.add(new TemplateVariable(name, type, value, label, this.getVariableParams(params)));
    }

    private String[] getVariableParams(String value) {
        if (value.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        int count = st.countTokens();
        String[] values = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            values[i] = st.nextToken().trim();
            ++i;
        }
        return values;
    }

    protected String getContents(Element element) throws IOException {
        Node child = element.getFirstChild();
        if (child != null) {
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    return child.getNodeValue().trim();
                }
            }
        }
        return null;
    }
}

