/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.LocalTemplateProject;
import com.tssap.selena.cmf.internal.templates.WorkspaceDeltaVisitor;
import com.tssap.selena.cmf.internal.templates.WorkspaceTemplateProject;
import com.tssap.selena.cmf.templates.ITemplateModel;
import com.tssap.selena.cmf.templates.ITemplateModelListener;
import com.tssap.selena.cmf.templates.ITemplateProject;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;

public class TemplateModel
implements ITemplateModel,
IResourceChangeListener,
IResourceDeltaVisitor {
    private int sync;
    private ITemplateProject[] projects;
    private HashMap projectMap = new HashMap();
    private ArrayList listeners = new ArrayList();
    private WorkspaceDeltaVisitor deltaVisitor = new WorkspaceDeltaVisitor();
    private LocalTemplateProject localProject;

    public TemplateModel() {
        CodePlugin.getInstance();
        IWorkspace workspace = CodePlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 22);
    }

    public String toString() {
        return "<TemplateModel id=" + Integer.toHexString(this.hashCode()) + " />";
    }

    private void ensureSync() {
        if (this.sync > 0) {
            return;
        }
        this.sync = 1;
        this.localProject = new LocalTemplateProject();
        this.projectMap.put("", this.localProject);
        CodePlugin.getInstance();
        IWorkspace workspace = CodePlugin.getWorkspace();
        IProject[] resources = workspace.getRoot().getProjects();
        int i = 0;
        while (i < resources.length) {
            IProject project = resources[i];
            try {
                if (project.isOpen()) {
                    if (project.hasNature("com.tssap.selena.cmf.TemplateNature")) {
                        this.addProject(project);
                    } else if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        CodeToolkit.addNature(project, "com.tssap.selena.cmf.TemplateNature", null);
                    }
                }
            }
            catch (CoreException e) {
                CodePlugin.warn("cannot add template project", e);
            }
            ++i;
        }
        this.projects = null;
        this.sync = 2;
    }

    public ITemplateProject getProject(IProject project) {
        if (project == null) {
            return this.localProject;
        }
        if (!project.isOpen()) {
            return null;
        }
        String name = project.getName();
        ITemplateProject prj = this.getProject(name);
        if (prj == null) {
            try {
                if (project.hasNature("com.tssap.selena.cmf.TemplateNature")) {
                    this.addProject(project);
                } else {
                    CodeToolkit.addNature(project, "com.tssap.selena.cmf.TemplateNature", null);
                }
            }
            catch (CoreException e) {
                CodePlugin.warn("cannot create template project", e);
            }
            prj = this.getProject(name);
        }
        return prj;
    }

    private ITemplateProject getProject(String name) {
        return (ITemplateProject)this.projectMap.get(name);
    }

    public ITemplateProject[] getProjects() {
        this.ensureSync();
        if (this.projects == null) {
            Collection values = this.projectMap.values();
            this.projects = values.toArray(new ITemplateProject[values.size()]);
        }
        return this.projects;
    }

    public boolean isEmpty() {
        return this.projectMap.isEmpty();
    }

    void addProject(IProject resource) {
        String name;
        if (resource.isOpen() && !this.projectMap.containsKey(name = resource.getName())) {
            CodePlugin.debug("adding template project {0}", name);
            WorkspaceTemplateProject project = new WorkspaceTemplateProject(resource);
            this.projectMap.put(name, project);
            this.projects = null;
            this.fireProjectAdded(project);
        }
    }

    void removeProject(IProject resource) {
        String name = resource.getName();
        ITemplateProject project = (ITemplateProject)this.projectMap.remove(name);
        if (project != null) {
            CodePlugin.debug("removing template project {0}", name);
            this.projects = null;
            this.fireProjectRemoved(project);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                this.removeProject((IProject)event.getResource());
                break;
            }
            case 16: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    event.getDelta().accept((IResourceDeltaVisitor)this.deltaVisitor);
                    break;
                }
                catch (CoreException e) {
                    CodePlugin.error(this.getClass().getName(), e);
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return this.visitProject(delta, (IProject)resource);
            }
        }
        return false;
    }

    private boolean isSynchronized() {
        return this.sync == 2;
    }

    private boolean visitProject(IResourceDelta delta, IProject project) throws CoreException {
        if (delta.getKind() == 1 && this.isSynchronized() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            try {
                CodeToolkit.addNature(project, "com.tssap.selena.cmf.TemplateNature", null);
            }
            catch (CoreException ex) {
                CodePlugin.warn("cannot add template project", ex);
            }
        }
        if ((delta.getFlags() & 0x4000) != 0 && project.isOpen() && project.hasNature("com.tssap.selena.cmf.TemplateNature")) {
            this.addProject(project);
        }
        return false;
    }

    public void addListener(ITemplateModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITemplateModelListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    public static void projectAdded(ITemplateProject project) {
        CodePlugin.getInstance().getTemplateModel().fireProjectAdded(project);
    }

    public void fireProjectAdded(ITemplateProject project) {
        if (this.listeners.size() == 0) {
            return;
        }
        ITemplateModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].projectAdded(project);
            ++i;
        }
    }

    public static void projectRemoved(ITemplateProject project) {
        CodePlugin.getInstance().getTemplateModel().fireProjectRemoved(project);
    }

    public void fireProjectRemoved(ITemplateProject project) {
        if (this.listeners.size() == 0) {
            return;
        }
        ITemplateModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].projectRemoved(project);
            ++i;
        }
    }

    public static void projectChanged(ITemplateProject project) {
        CodePlugin.getInstance().getTemplateModel().fireProjectChanged(project);
    }

    public void fireProjectChanged(ITemplateProject project) {
        if (this.sync != 2) {
            return;
        }
        if (this.listeners.size() == 0) {
            return;
        }
        ITemplateModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].projectChanged(project);
            ++i;
        }
    }

    private ITemplateModelListener[] getListeners() {
        ITemplateModelListener[] empty = new ITemplateModelListener[]{};
        int count = this.listeners.size();
        if (count == 0) {
            return empty;
        }
        return this.listeners.toArray(new ITemplateModelListener[count]);
    }
}

