/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ITemplateConstants;
import com.tssap.selena.cmf.internal.templates.TemplateModel;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateEngine;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.ITemplateProject;
import com.tssap.selena.cmf.templates.Templates;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class TemplateManager
extends PlatformObject
implements ITemplateManager,
ITemplateConstants {
    protected ITemplateExtension extension;
    protected ArrayList categories;
    protected ArrayList listeners;

    public TemplateManager(ITemplateExtension extension) {
        this.extension = extension;
        this.categories = new ArrayList();
        this.listeners = new ArrayList();
    }

    public String getName() {
        return this.getExtension().getName();
    }

    public ITemplateExtension getExtension() {
        return this.extension;
    }

    public boolean isEmpty() {
        return this.categories.size() == 0;
    }

    public ITemplate[] getTemplates() {
        return null;
    }

    public ITemplateCategory[] getCategories() {
        return this.categories.toArray(new ITemplateCategory[this.categories.size()]);
    }

    public void addCategory(ITemplateCategory category) {
        ITemplateEngine engine = Templates.getTemplateEngine();
        ITemplate[] templates = category.getTemplates();
        int i = 0;
        while (i < templates.length) {
            engine.addTemplate(templates[i]);
            ++i;
        }
        this.categories.add(category);
        TemplateModel.projectChanged(category.getManager().getProject());
    }

    public void removeCategory(ITemplateCategory category) {
        ITemplateEngine engine = Templates.getTemplateEngine();
        ITemplate[] templates = category.getTemplates();
        int i = 0;
        while (i < templates.length) {
            engine.removeTemplate(templates[i]);
            ++i;
        }
        ((AbstractCollection)this.categories).remove(category);
        TemplateModel.projectChanged(category.getManager().getProject());
    }

    public String toString() {
        return "<TemplateManager class=" + this.getClass().getName() + " />";
    }

    public abstract ITemplateCategory createCategory(String var1, IProgressMonitor var2) throws CoreException;

    public abstract ITemplateCategory getDefaultCategory();

    public abstract ITemplateProject getProject();
}

