/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateContext;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class TemplateExtension
implements IExecutableExtension,
ITemplateExtension {
    private static final String TAG_ROOT = "templates";
    private String id;
    private String name;
    private String icon;
    private String store;
    private String editor;
    private String wizard;
    private int index;
    private ImageDescriptor image;
    private int version;
    private boolean stringify;
    private boolean myIsInternal;
    private IConfigurationElement config;
    private ITemplate[] history;
    private ArrayList templates = new ArrayList();

    public String toString() {
        return "<TemplateExtension id=" + this.id + " name=" + this.name + " version=" + this.version + " />";
    }

    public void setInitializationData(IConfigurationElement el, String p, Object data) throws CoreException {
        this.id = el.getAttribute("id");
        this.name = el.getAttribute("name");
        this.icon = el.getAttribute("icon");
        this.store = el.getAttribute("store");
        this.editor = el.getAttribute("editor");
        this.wizard = el.getAttribute("newWizard");
        this.stringify = "true".equals(el.getAttribute("stringify"));
        this.myIsInternal = "true".equals(el.getAttribute("internal"));
        if (this.id == null || this.name == null || this.store == null) {
            throw new TemplateException("invalid template extension (missing markup) " + el);
        }
        String version = el.getAttribute("version");
        this.version = version == null ? 0 : Integer.valueOf(version);
        this.config = el;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    public String getId() {
        return this.id;
    }

    public String getEditorId() {
        return this.editor != null ? this.editor : this.id;
    }

    public String getNewWizardId() {
        return this.wizard != null ? this.wizard : this.id;
    }

    public boolean getStringify() {
        return this.stringify;
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public String getName() {
        return this.name;
    }

    public String getStore() {
        return this.store;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.icon != null && this.image == null) {
            try {
                URL base = this.config.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
                this.image = ImageDescriptor.createFromURL((URL)new URL(base, this.icon));
            }
            catch (IOException e) {
                this.image = ImageDescriptor.getMissingImageDescriptor();
                this.icon = null;
            }
        }
        return this.image;
    }

    public void addTemplate(ITemplate template) {
        if (this.templates.contains(template)) {
            throw new IllegalStateException("Template is added twice to the category:" + template);
        }
        this.templates.add(template);
    }

    public void removeTemplate(ITemplate template) {
        ((AbstractCollection)this.templates).remove(template);
    }

    public ITemplate[] getTemplates() {
        return this.templates.toArray(new ITemplate[this.templates.size()]);
    }

    public ITemplateContext createContext(ITemplateSource source) throws CoreException {
        Class contextClass = source.getContextClass();
        if (contextClass == null) {
            return this.createDefaultContext();
        }
        try {
            Object instance = contextClass.newInstance();
            return (ITemplateContext)instance;
        }
        catch (Exception e) {
            throw new TemplateException("illegal context " + contextClass);
        }
    }

    protected abstract ITemplateContext createDefaultContext() throws CoreException;

    public ITemplate[] getHistory() {
        if (this.history == null) {
            this.history = this.getTemplates();
        } else if (this.history.length != this.templates.size()) {
            ITemplate[] newHistory = this.getTemplates();
            System.arraycopy(this.history, 0, newHistory, 0, this.history.length);
        }
        return this.history;
    }

    public void updateHistory(ITemplate trigger) {
        ITemplate[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if (history[i] == trigger) {
                if (i == 0) {
                    return;
                }
                System.arraycopy(history, 0, history, 1, i);
                history[0] = trigger;
                return;
            }
            ++i;
        }
    }

    public abstract boolean isApplicable(Object[] var1, Class var2);

    public abstract void saveSource(OutputStream var1, ITemplateSource var2) throws IOException;

    public abstract ITemplateSource loadSource(InputStream var1) throws IOException;
}

