/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.IConstants;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateEngine;
import com.tssap.selena.cmf.templates.ITemplateEngineListener;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.Templates;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IMemento;

public class TemplateEngine
implements IConstants,
ITemplateEngine {
    private Object[] elements;
    private IStructuredSelection selection;
    private Class commonClass;
    private ITemplate[] history;
    private ArrayList historyList = new ArrayList();
    private ITemplate[] templates;
    private ArrayList templateList = new ArrayList();
    private ITemplate[] selectionHistory;
    private ITemplate[] selectionTemplates;
    private List myListeners;

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)selection);
        }
    }

    public void setSelection(IStructuredSelection selection) {
        if (!selection.equals(this.selection)) {
            this.setSelectionElements(selection.toArray());
        }
    }

    private void setSelectionElements(Object[] elements) {
        this.elements = elements;
        this.commonClass = CodeToolkit.getCommonClass(elements);
        this.selectionHistory = null;
        this.selectionTemplates = null;
    }

    public void addTemplate(ITemplate template) {
        this.templates = null;
        this.selectionTemplates = null;
        this.templateList.add(template);
        template.getExtension().addTemplate(template);
        this.addHistory(template);
        this.fireTemplateAdded(template);
    }

    public void removeTemplate(ITemplate template) {
        this.templates = null;
        this.selectionTemplates = null;
        ((AbstractCollection)this.templateList).remove(template);
        template.getExtension().removeTemplate(template);
        this.removeHistory(template);
        this.fireTemplateRemoved(template);
    }

    public void templateSourceAboutToChange(ITemplate template, ITemplateSource newSource) {
        this.fireTemplateSourceChanged(template, template.getSource(), newSource);
    }

    public ITemplate[] getTemplates() {
        if (this.templates == null) {
            this.templates = this.templateList.toArray(new ITemplate[this.templateList.size()]);
        }
        return this.templates;
    }

    public ITemplate[] getSelectionTemplates() {
        if (this.selectionTemplates == null) {
            this.selectionTemplates = this.getApplicableTemplates(this.getTemplates());
        }
        return this.selectionTemplates;
    }

    public ITemplateExtension[] getSelectionExtensions() {
        if (this.commonClass == null) {
            return IConstants.EMPTY_EXTENSION;
        }
        ArrayList<ITemplateExtension> list = new ArrayList<ITemplateExtension>();
        ITemplateExtension[] extensions = Templates.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].isApplicable(this.elements, this.commonClass)) {
                list.add(extensions[i]);
            }
            ++i;
        }
        return list.toArray(new ITemplateExtension[list.size()]);
    }

    public boolean hasSelectionTemplates() {
        if (this.commonClass == null) {
            return false;
        }
        if (this.selectionTemplates != null) {
            return this.selectionTemplates.length > 0;
        }
        ITemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            if (templates[i].getExtension().isApplicable(this.elements, this.commonClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addHistory(ITemplate template) {
        this.history = null;
        this.selectionHistory = null;
        this.historyList.add(template);
    }

    public void removeHistory(ITemplate template) {
        this.history = null;
        this.selectionHistory = null;
        ((AbstractCollection)this.historyList).remove(template);
    }

    public ITemplate[] getHistory() {
        if (this.history == null) {
            this.history = this.historyList.toArray(new ITemplate[this.historyList.size()]);
        }
        return this.history;
    }

    public ITemplate[] getSelectionHistory() {
        if (this.selectionHistory == null) {
            this.selectionHistory = this.getApplicableTemplates(this.getHistory());
        }
        return this.selectionHistory;
    }

    public void updateHistory(ITemplate template) {
        int length = this.historyList.size();
        int i = 0;
        while (i < length) {
            if (this.historyList.get(i) == template) {
                if (i <= 0) break;
                this.historyList.remove(i);
                this.historyList.add(0, template);
                this.history = null;
                break;
            }
            ++i;
        }
    }

    private ITemplate[] getApplicableTemplates(ITemplate[] templates) {
        if (this.commonClass == null) {
            return IConstants.EMPTY_TEMPLATES;
        }
        ArrayList<ITemplate> list = new ArrayList<ITemplate>();
        int i = 0;
        while (i < templates.length) {
            if (templates[i].getExtension().isApplicable(this.elements, this.commonClass)) {
                list.add(templates[i]);
            }
            ++i;
        }
        return list.toArray(new ITemplate[list.size()]);
    }

    public boolean isApplicable(ITemplate template) {
        return this.commonClass != null && template.getExtension().isApplicable(this.elements, this.commonClass);
    }

    public void saveState(IMemento memento) {
        ITemplate[] history = this.getHistory();
        int length = Math.min(10, history.length);
        int i = 0;
        while (i < length) {
            memento.createChild("history").putTextData(history[i].getLocation());
            ++i;
        }
    }

    public void restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren("history");
        if (children == null) {
            return;
        }
        ITemplate[] oldHistory = this.getHistory();
        ITemplate[] newHistory = new ITemplate[oldHistory.length];
        System.arraycopy(oldHistory, 0, newHistory, 0, oldHistory.length);
        int length = Math.min(children.length, newHistory.length);
        int i = 0;
        while (i < length) {
            String location = children[i].getTextData();
            if (location == null) break;
            int j = 0;
            while (j < newHistory.length) {
                if (location.equals(newHistory[j].getLocation())) {
                    if (i == j) break;
                    ITemplate tmp = newHistory[i];
                    newHistory[i] = newHistory[j];
                    newHistory[j] = tmp;
                    break;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < newHistory.length) {
            this.historyList.set(i2, newHistory[i2]);
            ++i2;
        }
        this.history = newHistory;
        this.selectionHistory = null;
    }

    public void addTemplateEngineListener(ITemplateEngineListener l) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList(3);
        }
        this.myListeners.add(l);
    }

    public void removeTemplateEngineListener(ITemplateEngineListener l) {
        if (this.myListeners != null) {
            this.myListeners.remove(l);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    protected void fireTemplateAdded(ITemplate template) {
        CodePlugin.debug("Firing template ({0}) added to {1} listeners.", template, new Integer(this.myListeners == null ? 0 : this.myListeners.size()));
        if (this.myListeners == null) {
            return;
        }
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((ITemplateEngineListener)it.next()).templateAdded(template);
        }
    }

    protected void fireTemplateRemoved(ITemplate template) {
        CodePlugin.debug("Firing template ({0}) removed to {1} listeners.", template, new Integer(this.myListeners == null ? 0 : this.myListeners.size()));
        if (this.myListeners == null) {
            return;
        }
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((ITemplateEngineListener)it.next()).templateRemoved(template);
        }
    }

    protected void fireTemplateSourceChanged(ITemplate template, ITemplateSource oldSource, ITemplateSource newSource) {
        if (this.myListeners == null) {
            return;
        }
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((ITemplateEngineListener)it.next()).templateSourceChanged(template, oldSource, newSource);
        }
    }
}

