/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateContext;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import com.tssap.selena.cmf.templates.TemplateException;
import com.tssap.selena.cmf.templates.Templates;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;

public abstract class TemplateContext
implements ITemplateContext {
    protected ITemplate template;
    protected Object[] selection;

    public void init(ITemplate template, Object[] selection) throws CoreException {
        if (template == null || selection == null || selection.length == 0) {
            throw new IllegalArgumentException();
        }
        this.template = template;
        this.selection = selection;
    }

    protected ITemplate getTemplate() {
        return this.template;
    }

    protected Object[] getSelection() {
        return this.selection;
    }

    public String isValid() {
        ITemplateVariable[] variables = this.template.getVariables();
        int i = 0;
        while (i < variables.length) {
            String valid = this.isValid(variables[i]);
            if (valid != null) {
                return valid;
            }
            ++i;
        }
        return null;
    }

    private String isValid(ITemplateVariable variable) {
        Object value = this.template.getVariableValue(variable);
        if (value == null) {
            return "unbound variable -- " + variable.getName();
        }
        if (value instanceof String && value.toString().length() == 0) {
            return "empty variable -- " + variable.getName();
        }
        return null;
    }

    public void apply(IProgressMonitor monitor) throws CoreException {
        String error = this.isValid();
        if (error != null) {
            throw new TemplateException(error);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(this.template.getName(), this.selection.length);
            int i = 0;
            while (i < this.selection.length) {
                Object target = this.selection[i];
                if (!this.accepts(target)) {
                    throw new IllegalArgumentException();
                }
                this.apply(target, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected boolean accepts(Object element) {
        return false;
    }

    protected void apply(Object target, IProgressMonitor monitor) throws CoreException {
    }

    protected final ISnippetContext createSnippetContext() throws CoreException {
        return Templates.createSnippetContext(this.template);
    }

    protected final ISnippetContext createSnippetContext(IType type) throws CoreException {
        ISnippetContext context = this.createSnippetContext();
        context.addVariable("packageName", type.getPackageFragment().getElementName());
        context.addVariable("className", type.getElementName());
        return context;
    }

    protected static final String format(ISnippet snippet, ISnippetContext context) throws CoreException {
        return snippet.render(context);
    }

    protected static final String format(ISnippet snippet, ISnippetContext context, int indent) throws CoreException {
        String code = snippet.render(context);
        return CodeToolkit.format(code, indent);
    }
}

