/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ITemplateConstants;
import com.tssap.selena.cmf.internal.templates.TemplateModel;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.Templates;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class TemplateCategory
extends PlatformObject
implements ITemplateCategory,
ITemplateConstants {
    protected String name;
    protected ArrayList templates;

    public TemplateCategory(String name) {
        this.name = name;
        this.templates = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.templates.isEmpty();
    }

    public void addTemplate(ITemplate template) {
        this.templates.add(template);
        Templates.getTemplateEngine().addTemplate(template);
        TemplateModel.projectChanged(this.getManager().getProject());
    }

    public void removeTemplate(ITemplate template) {
        ((AbstractCollection)this.templates).remove(template);
        Templates.getTemplateEngine().removeTemplate(template);
        TemplateModel.projectChanged(this.getManager().getProject());
    }

    public ITemplate findTemplate(String name) {
        ITemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            if (name.equals(templates[i].getName())) {
                return templates[i];
            }
            ++i;
        }
        return null;
    }

    public ITemplate[] getTemplates() {
        return this.templates.toArray(new ITemplate[this.templates.size()]);
    }

    public String toString() {
        return "<TemplateCategory name=" + this.name + " />";
    }

    public abstract void rename(String var1, IProgressMonitor var2) throws CoreException;

    public abstract void delete(IProgressMonitor var1) throws CoreException;

    public abstract ITemplate createTemplate(String var1, ITemplateSource var2, IProgressMonitor var3) throws CoreException;

    public abstract ITemplateManager getManager();
}

