/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.templates.BundleTemplate;
import com.tssap.selena.cmf.internal.templates.BundleTemplateCategory;
import com.tssap.selena.cmf.internal.templates.Messages;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class TemplateBundle {
    private URL templateURL;
    protected ITemplateExtension extension;
    protected ArrayList templates;
    protected ArrayList categories;

    public TemplateBundle(ITemplateExtension extension) {
        this.extension = extension;
        this.templates = new ArrayList();
        this.categories = new ArrayList();
        this.initTemplates();
    }

    public ITemplate[] getTemplates() {
        return this.templates.toArray(new ITemplate[this.templates.size()]);
    }

    public ITemplateCategory[] getCategories() {
        return this.categories.toArray(new ITemplateCategory[this.categories.size()]);
    }

    protected void initTemplates() {
        IMemento memento;
        try {
            memento = this.getInstallMemento();
        }
        catch (CoreException e) {
            memento = null;
        }
        if (memento != null) {
            this.initTemplates(memento);
        }
    }

    private void initTemplates(IMemento memento) {
        IMemento[] children = memento.getChildren("template");
        int i = 0;
        while (i < children.length) {
            try {
                this.loadTemplate(children[i]);
            }
            catch (Exception e) {
                CodePlugin.error("cannot load template", e);
            }
            ++i;
        }
    }

    private void loadTemplate(IMemento memento) throws CoreException {
        String name = memento.getString("name");
        String path = memento.getString("source");
        CodePlugin.debug("TemplateBundle.loadTemplate: {0}", path);
        ITemplateSource source = this.loadSource(path);
        String acategory = memento.getString("category");
        if (acategory == null) {
            acategory = Messages.getString("Misc_7");
        }
        BundleTemplateCategory category = this.createTemplateCategory(acategory);
        BundleTemplate template = new BundleTemplate(this.extension, category, name);
        template.setSource(source);
        category.addTemplate(template);
        this.templates.add(template);
    }

    private BundleTemplateCategory createTemplateCategory(String name) {
        BundleTemplateCategory category = this.getTemplateCategory(name);
        if (category == null) {
            category = new BundleTemplateCategory(name);
            this.categories.add(category);
        }
        return category;
    }

    private BundleTemplateCategory getTemplateCategory(String name) {
        int length = this.categories.size();
        int i = 0;
        while (i < length) {
            BundleTemplateCategory category = (BundleTemplateCategory)this.categories.get(i);
            if (name.equals(category.getName())) {
                return category;
            }
            ++i;
        }
        return null;
    }

    private ITemplateSource loadSource(String path) throws CoreException {
        try {
            return this.extension.loadSource(this.getInstallStream(path));
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private IMemento getInstallMemento() throws CoreException {
        try {
            InputStream in = this.getInstallStream(this.extension.getStore() + ".xml");
            InputStreamReader reader = new InputStreamReader(in, "utf-8");
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            reader.close();
            return memento;
        }
        catch (Exception e) {
            return null;
        }
    }

    private InputStream getInstallStream(String name) throws IOException {
        if (this.templateURL == null) {
            this.templateURL = this.getPluginDescriptor().find((IPath)new Path("$nl$/templates/"));
        }
        URL url = new URL(this.templateURL, name);
        return url.openConnection().getInputStream();
    }

    private IPluginDescriptor getPluginDescriptor() {
        return this.extension.getConfigurationElement().getDeclaringExtension().getDeclaringPluginDescriptor();
    }
}

