/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ITemplateConstants;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateContext;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateListener;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.Properties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class Template
extends PlatformObject
implements ITemplate,
ITemplateConstants {
    private ITemplateSource source;
    private List values;
    private List listeners;

    public ITemplateManager getManager() {
        return this.getCategory().getManager();
    }

    public ITemplateExtension getExtension() {
        return this.getManager().getExtension();
    }

    public ITemplateSource getSource() {
        return this.source;
    }

    public void setSource(ITemplateSource source) {
        this.source = source;
    }

    public ITemplateContext createContext() throws CoreException {
        return this.getExtension().createContext(this.source);
    }

    public void apply(Object[] selection, IProgressMonitor monitor) throws CoreException {
        ITemplateContext context = this.createContext();
        context.init(this, selection);
        context.apply(monitor);
    }

    public ITemplateVariable[] getVariables() {
        return this.source.getVariables();
    }

    public ITemplateVariable getVariable(String name) {
        ITemplateVariable[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length) {
            ITemplateVariable variable = variables[i];
            if (name.equals(variable.getName())) {
                return variable;
            }
            ++i;
        }
        return null;
    }

    public Object getVariableValue(String name) {
        return this.getVariableValue(this.getVariable(name));
    }

    public Object getVariableValue(ITemplateVariable variable) {
        if (variable == null) {
            throw new NullPointerException("variable == null");
        }
        String name = variable.getName();
        VariableValuePair vvp = this.getValue(name);
        if (vvp != null) {
            return vvp.value;
        }
        Object value = Template.getUnmarshalledValue(variable, variable.getValue());
        return value;
    }

    public void setVariableValue(String name, Object value) {
        this.setVariableValue(this.getVariable(name), value);
    }

    public void setVariableValue(ITemplateVariable variable, Object value) {
        if (variable == null) {
            throw new NullPointerException();
        }
        if (value instanceof String) {
            this.storeValue(variable.getName(), Template.getUnmarshalledValue(variable, (String)value));
        } else {
            this.storeValue(variable.getName(), value);
        }
        this.fireValueChanged(variable);
    }

    public void addListener(ITemplateListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(3);
        }
        this.listeners.add(listener);
    }

    public void removeListener(ITemplateListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected void fireValueChanged(ITemplateVariable variable) {
        if (this.listeners != null) {
            ITemplateListener[] targets = this.getListeners();
            int i = 0;
            while (i < targets.length) {
                targets[i].valueChanged(variable);
                ++i;
            }
        }
    }

    private ITemplateListener[] getListeners() {
        return this.listeners.toArray(new ITemplateListener[this.listeners.size()]);
    }

    private static Object getUnmarshalledValue(ITemplateVariable variable, String value) {
        String type = variable.getType();
        IPropertySupport support = Properties.getPropertySupport((String)type);
        IPropertyMarshaler marshaler = support.getPropertyMarshaler();
        return marshaler.unmarshal(value);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Template && this.equals((Template)o);
    }

    private boolean equals(Template that) {
        return this.source == that.source;
    }

    public String toString() {
        return "<Template name=" + this.getName() + " />";
    }

    private void initValuesStorage() {
        if (this.values == null) {
            this.values = new ArrayList(5);
        }
    }

    private VariableValuePair getValue(String variableName) {
        if (this.values == null) {
            return null;
        }
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            VariableValuePair next = (VariableValuePair)it.next();
            if (!variableName.equals(next.name)) continue;
            return next;
        }
        return null;
    }

    private void storeValue(String variableName, Object value) {
        this.initValuesStorage();
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            VariableValuePair next = (VariableValuePair)it.next();
            if (!variableName.equals(next.name)) continue;
            next.value = value;
            return;
        }
        this.values.add(new VariableValuePair(variableName, value));
    }

    public abstract void save(ITemplateSource var1, IProgressMonitor var2) throws CoreException;

    public abstract void rename(String var1, IProgressMonitor var2) throws CoreException;

    public abstract void delete(IProgressMonitor var1) throws CoreException;

    public abstract boolean exists();

    public abstract ITemplateCategory getCategory();

    public abstract String getLocation();

    public abstract String getName();

    private class VariableValuePair {
        String name;
        Object value;

        VariableValuePair(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

