/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.IConstants;
import com.tssap.selena.cmf.internal.templates.IStyleTemplateSource;
import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;

public class StyleTemplateSource
extends TemplateSource
implements IStyleTemplateSource {
    private static final String[] OPT_INSERT = new String[]{"insert", "do not insert"};
    private static final String[] OPT_CLEAR = new String[]{"clear all", "preserve one"};
    private static final String[] OPT_COMPACT = new String[]{"compact", "normal"};
    private SourceElement[] boilerplate;
    private String[] importOrder;
    private int importThreshold;
    private int formatTabSize;
    private int formatLineLength;
    private boolean formatIndentWithTab;
    private boolean formatNewLineBeforeOpeningBrace;
    private boolean formatNewLineInControlStatement;
    private boolean formatNewLineInEmptyBlock;
    private boolean formatClearBlankLines;
    private boolean formatCompactAssignment;
    private boolean formatCompactElseIf;

    public StyleTemplateSource() {
        this.boilerplate = IConstants.EMPTY_SOURCES;
        this.importOrder = IConstants.EMPTY_STRINGS;
    }

    public StyleTemplateSource(StyleTemplateSource source) {
        super(source);
        this.boilerplate = TemplateSource.copy(source.boilerplate);
        this.importOrder = TemplateSource.copy(source.getImportOrder());
        this.importThreshold = source.importThreshold;
        this.formatTabSize = source.formatTabSize;
        this.formatLineLength = source.formatLineLength;
        this.formatIndentWithTab = source.formatIndentWithTab;
        this.formatNewLineBeforeOpeningBrace = source.formatNewLineBeforeOpeningBrace;
        this.formatNewLineInControlStatement = source.formatNewLineInControlStatement;
        this.formatNewLineInEmptyBlock = source.formatNewLineInEmptyBlock;
        this.formatClearBlankLines = source.formatClearBlankLines;
        this.formatCompactAssignment = source.formatCompactAssignment;
        this.formatCompactElseIf = source.formatCompactElseIf;
    }

    public String toString() {
        return "<StyleTemplateSource variables=" + this.getVariables() + " formatCompactAssignment=" + this.formatCompactAssignment + " />";
    }

    public void loadFormatOptions() {
        this.loadFormatOptions(JavaCore.getOptions());
    }

    private void loadFormatOptions(Map map) {
        this.setFormatTabSize(Integer.parseInt((String)map.get("org.eclipse.jdt.core.formatter.tabulation.size")));
        this.setFormatLineLength(Integer.parseInt((String)map.get("org.eclipse.jdt.core.formatter.lineSplit")));
        this.setFormatNewLineBeforeOpeningBrace(this.getOption(map, "org.eclipse.jdt.core.formatter.newline.openingBrace", OPT_INSERT));
        this.setFormatNewLineInControlStatement(this.getOption(map, "org.eclipse.jdt.core.formatter.newline.controlStatement", OPT_INSERT));
        this.setFormatNewLineInEmptyBlock(this.getOption(map, "org.eclipse.jdt.core.formatter.newline.emptyBlock", OPT_INSERT));
        this.setFormatClearBlankLines(this.getOption(map, "org.eclipse.jdt.core.formatter.newline.clearAll", OPT_CLEAR));
        this.setFormatCompactAssignment(this.getOption(map, "org.eclipse.jdt.core.formatter.style.assignment", OPT_COMPACT));
        this.setFormatCompactElseIf(this.getOption(map, "org.eclipse.jdt.core.formatter.newline.elseIf", OPT_INSERT));
    }

    public void saveFormatOptions() {
        this.saveFormatOptions(JavaCore.getOptions());
    }

    private void saveFormatOptions(Map map) {
        map.put("org.eclipse.jdt.core.formatter.tabulation.size", String.valueOf(this.getFormatTabSize()));
        map.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(this.getFormatLineLength()));
        this.setOption(map, "org.eclipse.jdt.core.formatter.newline.openingBrace", OPT_INSERT, this.getFormatNewLineBeforeOpeningBrace());
        this.setOption(map, "org.eclipse.jdt.core.formatter.newline.controlStatement", OPT_INSERT, this.getFormatNewLineInControlStatement());
        this.setOption(map, "org.eclipse.jdt.core.formatter.newline.emptyBlock", OPT_INSERT, this.getFormatNewLineInEmptyBlock());
        this.setOption(map, "org.eclipse.jdt.core.formatter.newline.clearAll", OPT_CLEAR, this.getFormatClearBlankLines());
        this.setOption(map, "org.eclipse.jdt.core.formatter.style.assignment", OPT_COMPACT, this.getFormatCompactAssignment());
        this.setOption(map, "org.eclipse.jdt.core.formatter.newline.elseIf", OPT_INSERT, this.getFormatCompactElseIf());
    }

    private boolean getOption(Map map, String key, String[] choice) {
        return choice[0].equals(map.get(key));
    }

    private void setOption(Map map, String key, String[] choice, boolean value) {
        map.put(key, value ? choice[0] : choice[1]);
    }

    public ISnippet getHeader() {
        int i = 0;
        while (i < this.boilerplate.length) {
            SourceElement element = this.boilerplate[i];
            if ("header".equals(element.getName().getInput())) {
                return element.getContents();
            }
            ++i;
        }
        return IConstants.EMPTY_SNIPPET;
    }

    public SourceElement[] getBoilerplate() {
        return this.boilerplate;
    }

    public void setBoilerplate(SourceElement[] boilerplate) {
        this.boilerplate = boilerplate;
    }

    public String[] getImportOrder() {
        return this.importOrder;
    }

    public void setImportOrder(String[] importOrder) {
        this.importOrder = importOrder;
    }

    public int getImportThreshold() {
        return this.importThreshold;
    }

    public void setImportThreshold(int importThreshold) {
        this.importThreshold = importThreshold;
    }

    public int getFormatTabSize() {
        return this.formatTabSize;
    }

    public void setFormatTabSize(int formatTabSize) {
        this.formatTabSize = formatTabSize;
    }

    public int getFormatLineLength() {
        return this.formatLineLength;
    }

    public void setFormatLineLength(int formatLineLength) {
        this.formatLineLength = formatLineLength;
    }

    public boolean getFormatIndentWithTab() {
        return this.formatIndentWithTab;
    }

    public void setFormatIndentWithTab(boolean formatIndentWithTab) {
        this.formatIndentWithTab = formatIndentWithTab;
    }

    public boolean getFormatNewLineBeforeOpeningBrace() {
        return this.formatNewLineBeforeOpeningBrace;
    }

    public void setFormatNewLineBeforeOpeningBrace(boolean formatNewLineBeforeOpeningBrace) {
        this.formatNewLineBeforeOpeningBrace = formatNewLineBeforeOpeningBrace;
    }

    public boolean getFormatNewLineInControlStatement() {
        return this.formatNewLineInControlStatement;
    }

    public void setFormatNewLineInControlStatement(boolean formatNewLineInControlStatement) {
        this.formatNewLineInControlStatement = formatNewLineInControlStatement;
    }

    public boolean getFormatNewLineInEmptyBlock() {
        return this.formatNewLineInEmptyBlock;
    }

    public void setFormatNewLineInEmptyBlock(boolean formatNewLineInEmptyBlock) {
        this.formatNewLineInEmptyBlock = formatNewLineInEmptyBlock;
    }

    public boolean getFormatClearBlankLines() {
        return this.formatClearBlankLines;
    }

    public void setFormatClearBlankLines(boolean formatClearBlankLines) {
        this.formatClearBlankLines = formatClearBlankLines;
    }

    public boolean getFormatCompactAssignment() {
        return this.formatCompactAssignment;
    }

    public void setFormatCompactAssignment(boolean formatCompactAssignment) {
        this.formatCompactAssignment = formatCompactAssignment;
    }

    public boolean getFormatCompactElseIf() {
        return this.formatCompactElseIf;
    }

    public void setFormatCompactElseIf(boolean formatCompactElseIf) {
        this.formatCompactElseIf = formatCompactElseIf;
    }

    protected void validate(ISnippetContext context) throws CoreException {
        this.validateSnippets(context, this.getBoilerplate());
    }
}

