/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.StyleTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateReader;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.Templates;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class StyleTemplateReader
extends TemplateReader {
    private ArrayList boilerplate = new ArrayList();
    private ArrayList importOrder = new ArrayList();
    private int importThreshold = 99;
    private int formatTabSize = 8;
    private int formatLineLength = 80;
    private boolean formatIndentWithTab = true;
    private boolean formatNewLineBeforeOpeningBrace = false;
    private boolean formatNewLineInControlStatement = false;
    private boolean formatNewLineInEmptyBlock = true;
    private boolean formatClearBlankLines = false;
    private boolean formatCompactAssignment = false;
    private boolean formatCompactElseIf = false;

    public StyleTemplateReader(InputStream in, ITemplateExtension extension) {
        super(in, extension);
    }

    protected TemplateSource createSource() {
        StyleTemplateSource source = new StyleTemplateSource();
        source.setBoilerplate(this.getBoilerplate());
        source.setImportOrder(this.getImportOrder());
        source.setImportThreshold(this.importThreshold);
        source.setFormatTabSize(this.formatTabSize);
        source.setFormatLineLength(this.formatLineLength);
        source.setFormatIndentWithTab(this.formatIndentWithTab);
        source.setFormatNewLineBeforeOpeningBrace(this.formatNewLineBeforeOpeningBrace);
        source.setFormatNewLineInControlStatement(this.formatNewLineInControlStatement);
        source.setFormatNewLineInEmptyBlock(this.formatNewLineInEmptyBlock);
        source.setFormatClearBlankLines(this.formatClearBlankLines);
        source.setFormatCompactAssignment(this.formatCompactAssignment);
        source.setFormatCompactElseIf(this.formatCompactElseIf);
        return source;
    }

    public SourceElement[] getBoilerplate() {
        return this.boilerplate.toArray(new SourceElement[this.boilerplate.size()]);
    }

    public String[] getImportOrder() {
        return this.importOrder.toArray(new String[this.importOrder.size()]);
    }

    protected void addElement(Element element) throws IOException {
        String name = element.getNodeName();
        if ("boilerplate".equals(name)) {
            this.addBoilerplate(element);
        } else if ("importOrder".equals(name)) {
            this.addImportOrder(element);
        } else if ("importThreshold".equals(name)) {
            this.importThreshold = this.getInteger(element);
        } else if ("formatTabSize".equals(name)) {
            this.formatTabSize = this.getInteger(element);
        } else if ("formatLineLength".equals(name)) {
            this.formatLineLength = this.getInteger(element);
        } else if ("formatIndentWithTab".equals(name)) {
            this.formatIndentWithTab = this.getBoolean(element);
        } else if ("formatNewLineBeforeOpeningBrace".equals(name)) {
            this.formatNewLineBeforeOpeningBrace = this.getBoolean(element);
        } else if ("formatNewLineInControlStatement".equals(name)) {
            this.formatNewLineInControlStatement = this.getBoolean(element);
        } else if ("formatNewLineInEmptyBlock".equals(name)) {
            this.formatNewLineInEmptyBlock = this.getBoolean(element);
        } else if ("formatClearBlankLines".equals(name)) {
            this.formatClearBlankLines = this.getBoolean(element);
        } else if ("formatCompactAssignment".equals(name)) {
            this.formatCompactAssignment = this.getBoolean(element);
        } else if ("formatCompactElseIf".equals(name)) {
            this.formatCompactElseIf = this.getBoolean(element);
        } else {
            super.addElement(element);
        }
    }

    private void addBoilerplate(Element element) throws IOException {
        String name = element.getAttribute("name");
        String contents = this.getContents(element);
        if (name == null || contents == null) {
            throw new IOException("bogus boilerplate");
        }
        this.boilerplate.add(new SourceElement(Templates.createSnippet(name), Templates.createSnippet(contents)));
    }

    private void addImportOrder(Element element) throws IOException {
        String contents = this.getContents(element);
        if (contents == null) {
            throw new IOException("missing contents");
        }
        this.importOrder.add(contents);
    }

    private String getString(Element element) throws IOException {
        String contents = this.getContents(element);
        if (contents == null) {
            throw new IOException("missing contents");
        }
        return contents;
    }

    private int getInteger(Element element) throws IOException {
        try {
            return Integer.parseInt(this.getString(element));
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private boolean getBoolean(Element element) throws IOException {
        return this.getString(element).equals("true");
    }
}

