/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.IStyleTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateContext;
import com.tssap.selena.cmf.internal.templates.TypeTemplateContext;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.formatter.CodeFormatter;
import org.eclipse.jdt.internal.formatter.impl.FormatterOptions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class StyleTemplateContext
extends TypeTemplateContext {
    private IStyleTemplateSource source;
    private FormatterOptions formatterOptions;

    public void init(ITemplate template, Object[] selection) throws CoreException {
        this.source = (IStyleTemplateSource)template.getSource();
        super.init(template, selection);
    }

    private CodeFormatter createCodeFormatter() {
        CodeFormatter formatter = new CodeFormatter();
        formatter.options = this.formatterOptions;
        return formatter;
    }

    private FormatterOptions createFormatterOptions(IStyleTemplateSource source) {
        if (this.formatterOptions == null) {
            this.formatterOptions = new FormatterOptions();
        }
        this.formatterOptions.tabSize = source.getFormatTabSize();
        this.formatterOptions.maxLineLength = source.getFormatLineLength();
        this.formatterOptions.indentWithTab = source.getFormatIndentWithTab();
        this.formatterOptions.newLineBeforeOpeningBraceMode = source.getFormatNewLineBeforeOpeningBrace();
        this.formatterOptions.newlineInControlStatementMode = source.getFormatNewLineInControlStatement();
        this.formatterOptions.newLineInEmptyBlockMode = source.getFormatNewLineInEmptyBlock();
        this.formatterOptions.clearAllBlankLinesMode = source.getFormatClearBlankLines();
        this.formatterOptions.compactAssignmentMode = source.getFormatCompactAssignment();
        this.formatterOptions.compactElseIfMode = source.getFormatCompactElseIf();
        return this.formatterOptions;
    }

    protected void apply(Object target, IProgressMonitor monitor) throws CoreException {
        this.createFormatterOptions(this.source);
        super.apply(target, monitor);
    }

    protected void work(IType type) throws CoreException {
        ICompilationUnit unit = type.getCompilationUnit();
        if (this.source.getImportThreshold() > 0) {
            this.organizeImports(unit, this.source);
        }
        IDocumentProvider provider = this.getDocumentProvider();
        IFile file = (IFile)unit.getUnderlyingResource();
        FileEditorInput input = new FileEditorInput(file);
        provider.connect((Object)input);
        IDocument document = provider.getDocument((Object)input);
        provider.getAnnotationModel((Object)input).connect(document);
        IPackageDeclaration[] packages = unit.getPackageDeclarations();
        if (packages.length > 0) {
            ISnippetContext context = this.createSnippetContext(type);
            String code = TemplateContext.format(this.source.getHeader(), context, 0).trim();
            ISourceRange range = packages[0].getSourceRange();
            try {
                document.replace(0, range.getOffset(), code);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        document.set(this.formatCode(document.get()));
        try {
            provider.aboutToChange((Object)input);
            provider.saveDocument(null, (Object)input, document, true);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            provider.changed((Object)input);
            throw throwable;
        }
        provider.changed((Object)input);
    }

    private IDocumentProvider getDocumentProvider() {
        return JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
    }

    private String formatCode(String content) throws CoreException {
        return content;
    }

    private void organizeImports(ICompilationUnit unit, IStyleTemplateSource source) {
    }
}

