/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.templates.LocalTemplateManager;
import com.tssap.selena.cmf.internal.templates.SnippetContext;
import com.tssap.selena.cmf.internal.templates.SnippetException;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.exception.ReferenceException;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.eclipse.core.runtime.CoreException;

public final class Snippet
implements ISnippet {
    private static final String LOG_TAG = "snippet";
    private static SnippetRuntime runtime;
    private String input;
    private SimpleNode syntax;

    private static SnippetRuntime getRuntime() throws CoreException {
        if (runtime == null) {
            try {
                runtime = Snippet.createRuntime();
            }
            catch (Exception e) {
                throw new SnippetException(e);
            }
        }
        return runtime;
    }

    private static SnippetRuntime createRuntime() throws Exception {
        SnippetRuntime runtime = new SnippetRuntime();
        if (CodePlugin.getInstance().isLoggingVelocityMessages()) {
            runtime.setProperty("runtime.log.logsystem", new Log());
        } else {
            runtime.setProperty("runtime.log.logsystem", new NullLogSystem());
        }
        String path = LocalTemplateManager.getTemplatesDirectory().toString();
        runtime.setProperty("file.resource.loader.path", path);
        runtime.setProperty("velocimacro.library", "");
        runtime.init();
        return runtime;
    }

    public Snippet(String input) {
        this.input = input;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
        this.syntax = null;
    }

    public String render(ISnippetContext context) throws CoreException {
        if (context instanceof SnippetContext) {
            return this.render((SnippetContext)context);
        }
        throw new SnippetException("illegal snippet context: " + context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String render(SnippetContext context) throws CoreException {
        InternalContextAdapterImpl ica;
        SnippetRuntime runtime;
        block8: {
            String string;
            runtime = Snippet.getRuntime();
            if (this.syntax == null) {
                try {
                    BufferedReader reader = new BufferedReader(new StringReader(this.input));
                    this.syntax = runtime.parse(reader, LOG_TAG);
                }
                catch (ParseException e) {
                    throw new SnippetException(e);
                }
            }
            ica = new InternalContextAdapterImpl((Context)context);
            ica.pushCurrentTemplateName(LOG_TAG);
            runtime.setErrorMessage(null);
            try {
                try {
                    this.syntax.init((InternalContextAdapter)ica, (Object)runtime);
                    if (runtime.getErrorMessage() != null) break block8;
                    StringWriter writer = new StringWriter();
                    this.syntax.render((InternalContextAdapter)ica, (Writer)writer);
                    if (runtime.getErrorMessage() != null) break block8;
                    string = writer.toString();
                    Object var7_8 = null;
                }
                catch (Exception e) {
                    throw new SnippetException(e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                ica.popCurrentTemplateName();
                throw throwable;
            }
            ica.popCurrentTemplateName();
            return string;
        }
        Object var7_9 = null;
        ica.popCurrentTemplateName();
        throw new SnippetException(runtime.getErrorMessage());
    }

    static class SnippetRuntime
    extends RuntimeInstance {
        private String errorMessage;

        SnippetRuntime() {
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void error(Object message) {
            if (message instanceof ReferenceException) {
                this.setErrorMessage(message.toString());
            }
            super.error(message);
        }

        public void warn(Object message) {
            if (message instanceof ReferenceException) {
                this.setErrorMessage(message.toString());
            }
            super.warn(message);
        }
    }

    static class Log
    implements LogSystem {
        Log() {
        }

        public void init(RuntimeServices rs) {
        }

        public void logVelocityMessage(int level, String message) {
            switch (level) {
                case 3: {
                    CodePlugin.error(message);
                    break;
                }
                case 0: {
                    CodePlugin.debug(message);
                    break;
                }
                case 1: 
                case 2: {
                    CodePlugin.info(message);
                }
            }
        }
    }
}

