/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ClasspathElement;
import com.tssap.selena.cmf.internal.templates.IProjectTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateWriter;
import com.tssap.selena.cmf.internal.templates.UnitElement;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateSource;
import java.io.OutputStream;
import org.w3c.dom.Element;

public class ProjectTemplateWriter
extends TemplateWriter {
    public ProjectTemplateWriter(OutputStream out, ITemplateExtension extension) {
        super(out, extension);
    }

    public void addElements(ITemplateSource source) {
        super.addElements(source);
        this.addElements((IProjectTemplateSource)source);
    }

    private void addElements(IProjectTemplateSource source) {
        String[] natures = source.getNatures();
        int i = 0;
        while (i < natures.length) {
            this.addNature(natures[i]);
            ++i;
        }
        ClasspathElement[] classpath = source.getClasspathEntries();
        int i2 = 0;
        while (i2 < classpath.length) {
            this.addClasspathEntry(classpath[i2]);
            ++i2;
        }
        UnitElement[] units = source.getCompilationUnits();
        int i3 = 0;
        while (i3 < units.length) {
            this.addCompilationUnit(units[i3]);
            ++i3;
        }
    }

    protected void addNature(String id) {
        Element element = this.createTextElement("nature", id);
        this.addElement(element);
    }

    protected void addClasspathEntry(ClasspathElement cpe) {
        String kind;
        switch (cpe.getKind()) {
            case 1: {
                kind = "lib";
                break;
            }
            case 4: {
                kind = "var";
                break;
            }
            default: {
                return;
            }
        }
        Element element = this.createElement("classpath");
        element.setAttribute("kind", kind);
        element.setAttribute("path", cpe.getPath().getInput());
        this.addElement(element);
    }

    protected void addCompilationUnit(UnitElement ue) {
        Element element = this.createDataElement("unit", ue.getContents());
        element.setAttribute("name", ue.getName().getInput());
        ISnippet value = ue.getFragment();
        if (value != null) {
            element.setAttribute("package", value.getInput());
        }
        this.addElement(element);
    }
}

