/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ClasspathElement;
import com.tssap.selena.cmf.internal.templates.PackageTemplateReader;
import com.tssap.selena.cmf.internal.templates.ProjectTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.Templates;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Element;

public final class ProjectTemplateReader
extends PackageTemplateReader {
    protected ArrayList natures = new ArrayList();
    protected ArrayList classpaths = new ArrayList();

    public ProjectTemplateReader(InputStream in, ITemplateExtension extension) {
        super(in, extension);
    }

    protected TemplateSource createSource() {
        ProjectTemplateSource source = new ProjectTemplateSource();
        source.setCompilationUnits(this.getCompilationUnits());
        source.setNatures(this.getNatures());
        source.setClasspathEntries(this.getClasspathEntries());
        return source;
    }

    public String[] getNatures() {
        return this.natures.toArray(new String[this.natures.size()]);
    }

    public ClasspathElement[] getClasspathEntries() {
        return this.classpaths.toArray(new ClasspathElement[this.classpaths.size()]);
    }

    protected void addElement(Element element) throws IOException {
        String name = element.getNodeName();
        if ("nature".equals(name)) {
            this.addNature(element);
        } else if ("classpath".equals(name)) {
            this.addClasspath(element);
        } else {
            super.addElement(element);
        }
    }

    private void addNature(Element element) throws IOException {
        String contents = this.getContents(element);
        if (contents == null) {
            throw new IOException("missing nature markup");
        }
        this.natures.add(contents);
    }

    private void addClasspath(Element element) throws IOException {
        int cpe;
        String kind = element.getAttribute("kind");
        String path = element.getAttribute("path");
        if (kind == null || path == null) {
            throw new IOException("missing classpath markup");
        }
        if (kind.equals("lib")) {
            cpe = 1;
        } else if (kind.equals("var")) {
            cpe = 4;
        } else {
            throw new IOException("illegal classpath kind: " + kind);
        }
        this.classpaths.add(new ClasspathElement(cpe, Templates.createSnippet(path)));
    }
}

