/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.ClasspathElement;
import com.tssap.selena.cmf.internal.templates.IProjectTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateContext;
import com.tssap.selena.cmf.internal.templates.UnitElement;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class ProjectTemplateContext
extends TemplateContext {
    private IProjectTemplateSource source;
    private ISnippetContext context;

    public void init(ITemplate template, Object[] selection) throws CoreException {
        this.source = (IProjectTemplateSource)template.getSource();
        super.init(template, selection);
    }

    protected boolean accepts(Object element) {
        return element instanceof IJavaProject;
    }

    protected void apply(Object target, IProgressMonitor monitor) throws CoreException {
        this.apply((IJavaProject)target, monitor);
    }

    private void apply(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        this.context = this.createSnippetContext();
        this.context.addVariable("projectName", project.getElementName());
        UnitElement[] units = this.source.getCompilationUnits();
        monitor.beginTask(project.getElementName(), 3 * units.length);
        try {
            IClasspathEntry[] classpath = this.createRawClasspath(project, this.source.getClasspathEntries());
            project.setRawClasspath(classpath, monitor);
            monitor.worked(units.length);
            IPackageFragmentRoot root = this.getPackageFragmentRoot(project);
            IPackageFragment defaultFragment = root.getPackageFragment("");
            int i = 0;
            while (i < units.length) {
                UnitElement element = units[i];
                String className = TemplateContext.format(element.getName(), this.context);
                String packageName = TemplateContext.format(element.getFragment(), this.context);
                this.context.addVariable("className", className);
                this.context.addVariable("packageName", packageName);
                IPackageFragment fragment = this.createPackageFragment(packageName, root, defaultFragment);
                String code = TemplateContext.format(element.getContents(), this.context, 0);
                fragment.createCompilationUnit(className + ".java", code, false, null);
                monitor.worked(1);
                ++i;
            }
            CodeToolkit.addNatures(project.getProject(), this.source.getNatures(), (IProgressMonitor)new SubProgressMonitor(monitor, units.length));
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaProject project) throws CoreException {
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                return root;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private IPackageFragment createPackageFragment(String name, IPackageFragmentRoot root, IPackageFragment defaultFragment) throws CoreException {
        if (name == null) {
            return defaultFragment;
        }
        IPackageFragment fragment = root.getPackageFragment(name);
        if (!fragment.exists()) {
            fragment = root.createPackageFragment(name, false, null);
        }
        return fragment;
    }

    private IClasspathEntry[] createRawClasspath(IJavaProject project, ClasspathElement[] elements) throws CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] classpath = project.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            entries.add(entry);
            ++i;
        }
        int i2 = 0;
        while (i2 < elements.length) {
            ClasspathElement element = elements[i2];
            String path = TemplateContext.format(element.getPath(), this.context);
            if (this.getClasspathEntry(classpath, path) == null) {
                entries.add(ProjectTemplateContext.createClasspathEntry(element.getKind(), path));
            }
            ++i2;
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private IClasspathEntry getClasspathEntry(IClasspathEntry[] classpath, String path) {
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (path.equals(entry.getPath().toString())) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private static IClasspathEntry createClasspathEntry(int kind, String path) {
        switch (kind) {
            case 1: {
                return JavaCore.newLibraryEntry((IPath)new Path(path), null, null);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)new Path(path), null, null);
            }
        }
        throw new IllegalStateException();
    }
}

