/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.PatternTemplateSource;
import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateReader;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.Templates;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class PatternTemplateReader
extends TemplateReader {
    private ArrayList snippets = new ArrayList();

    public PatternTemplateReader(InputStream in, ITemplateExtension extension) {
        super(in, extension);
    }

    protected TemplateSource createSource() {
        PatternTemplateSource source = new PatternTemplateSource();
        source.setSnippets(this.getSnippets());
        return source;
    }

    public SourceElement[] getSnippets() {
        return this.snippets.toArray(new SourceElement[this.snippets.size()]);
    }

    protected void addElement(Element element) throws IOException {
        String name = element.getNodeName();
        if ("snippet".equals(name)) {
            this.addSnippet(element);
        } else {
            super.addElement(element);
        }
    }

    private void addSnippet(Element element) throws IOException {
        String name = element.getAttribute("name");
        String contents = this.getContents(element);
        if (name == null || contents == null) {
            throw new IOException("bogus snippet");
        }
        this.snippets.add(new SourceElement(Templates.createSnippet(name), Templates.createSnippet(contents)));
    }
}

