/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.IPatternTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateContext;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateVariable;
import com.tssap.selena.cmf.templates.TemplateException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;

public abstract class PatternTemplateContext
extends TemplateContext {
    protected IPatternTemplateSource source;
    protected IJavaProject project;

    public IPatternTemplateSource getTemplateSource() {
        return this.source;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public void init(ITemplate template, Object[] selection) throws CoreException {
        this.source = (IPatternTemplateSource)template.getSource();
        super.init(template, selection);
    }

    public void apply(IProgressMonitor monitor) throws CoreException {
        Object element;
        String error = this.isValid();
        if (error != null) {
            throw new TemplateException(error);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!((element = this.selection[0]) instanceof IJavaElement)) {
            throw new IllegalStateException();
        }
        this.project = ((IJavaElement)element).getJavaProject();
        this.run(monitor);
    }

    public abstract void run(IProgressMonitor var1) throws CoreException;

    protected static IType selectClass(Object[] selection) throws CoreException {
        int i = 0;
        while (i < selection.length) {
            Object element = selection[i];
            if (element instanceof IType) {
                return (IType)element;
            }
            if (element instanceof ICompilationUnit) {
                return ((ICompilationUnit)element).getTypes()[0];
            }
            ++i;
        }
        return null;
    }

    protected static IPackageFragment selectPackage(Object[] selection) throws CoreException {
        int i = 0;
        while (i < selection.length) {
            Object element = selection[i];
            if (element instanceof IPackageFragment) {
                return (IPackageFragment)element;
            }
            ++i;
        }
        return null;
    }

    protected Object selectClass(ITemplateVariable variable, Object[] selection) throws CoreException {
        IType type = PatternTemplateContext.selectClass(selection);
        if (type != null) {
            return type.getFullyQualifiedName();
        }
        return this.selectDefaultClass(variable, selection);
    }

    protected Object selectDefaultClass(ITemplateVariable variable, Object[] selection) throws CoreException {
        IPackageFragment fragment = PatternTemplateContext.selectPackage(selection);
        if (fragment != null) {
            String className = PatternTemplateContext.getClassName(variable.getValue());
            String packageName = fragment.getElementName();
            return PatternTemplateContext.createQualifiedName(packageName, className);
        }
        return variable.getValue();
    }

    protected ISnippet getSnippet(String name) throws CoreException {
        ISnippet snippet = this.getTemplateSource().getSnippet(name);
        if (snippet == null) {
            throw new TemplateException("missing snippet -- " + name);
        }
        return snippet;
    }

    protected IType findClass(Object value) throws CoreException {
        if (value instanceof IType) {
            return (IType)value;
        }
        ICompilationUnit unit = this.findCompilationUnit(value.toString());
        IType[] types = unit.getTypes();
        if (types.length == 0) {
            throw new TemplateException("bogus compilation unit");
        }
        return types[0];
    }

    private ICompilationUnit findCompilationUnit(String qualifiedName) throws CoreException {
        String className = PatternTemplateContext.getClassName(qualifiedName);
        String packageName = PatternTemplateContext.getPackageName(qualifiedName);
        return this.findCompilationUnit(className, packageName);
    }

    private ICompilationUnit findCompilationUnit(String className, String packageName) throws CoreException {
        String unitName;
        ICompilationUnit unit;
        IPackageFragmentRoot fragmentRoot = PatternTemplateContext.getPackageFragmentRoot(this.project);
        IPackageFragment fragment = this.findPackageFragment(packageName, fragmentRoot);
        if (fragment != null && (unit = fragment.getCompilationUnit(unitName = className + ".java")).exists()) {
            return unit;
        }
        return null;
    }

    private IPackageFragment findPackageFragment(String name, IPackageFragmentRoot fragmentRoot) throws CoreException {
        IPackageFragment fragment = fragmentRoot.getPackageFragment(name);
        if (fragment.exists()) {
            return fragment;
        }
        return null;
    }

    public static IField createField(IType type, ISnippet snippet, ISnippetContext context) throws CoreException {
        String code = snippet.render(context);
        return type.createField(CodeToolkit.format(code, 1), null, false, null);
    }

    public static IMethod createMethod(IType type, ISnippet snippet, ISnippetContext context) throws CoreException {
        String code = snippet.render(context);
        return type.createMethod(CodeToolkit.format(code, 1), null, false, null);
    }

    protected IType createClass(String snippet, Object value) throws CoreException {
        if (value instanceof IType) {
            return (IType)value;
        }
        ICompilationUnit unit = this.createCompilationUnit(snippet, value.toString());
        IType[] types = unit.getTypes();
        if (types.length == 0) {
            throw new TemplateException("bogus compilation unit");
        }
        return types[0];
    }

    protected ICompilationUnit createCompilationUnit(String snippet, String qualifiedName) throws CoreException {
        String className = PatternTemplateContext.getClassName(qualifiedName);
        String packageName = PatternTemplateContext.getPackageName(qualifiedName);
        return this.createCompilationUnit(snippet, className, packageName);
    }

    protected ICompilationUnit createCompilationUnit(String snippet, String className, String packageName) throws CoreException {
        String unitName;
        IPackageFragment defaultFragment;
        IPackageFragmentRoot fragmentRoot = PatternTemplateContext.getPackageFragmentRoot(this.project);
        IPackageFragment fragment = this.createPackageFragment(packageName, fragmentRoot, defaultFragment = fragmentRoot.getPackageFragment(""));
        ICompilationUnit unit = fragment.getCompilationUnit(unitName = className + ".java");
        if (!unit.exists()) {
            ISnippetContext context = this.createSnippetContext();
            context.addVariable("className", className);
            context.addVariable("packageName", packageName);
            String code = TemplateContext.format(this.getSnippet(snippet), context, 0);
            unit = fragment.createCompilationUnit(unitName, code, true, null);
            if (packageName.length() > 0) {
                unit.createPackageDeclaration(packageName, null);
            }
        }
        return unit;
    }

    protected IPackageFragment createPackageFragment(String name, IPackageFragmentRoot fragmentRoot, IPackageFragment defaultFragment) throws CoreException {
        if (name == null || name.length() == 0) {
            return defaultFragment;
        }
        IPackageFragment fragment = fragmentRoot.getPackageFragment(name);
        if (!fragment.exists()) {
            fragment = fragmentRoot.createPackageFragment(name, true, null);
        }
        return fragment;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IJavaProject project) throws CoreException {
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                return root;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public static String getClassName(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String getPackageName(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(0, i);
    }

    public static String createQualifiedName(String packageName, String className) {
        if (packageName == null || packageName.length() == 0) {
            return className;
        }
        return packageName + '.' + className;
    }
}

