/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.PackageTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateReader;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.internal.templates.UnitElement;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.Templates;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class PackageTemplateReader
extends TemplateReader {
    protected ArrayList units = new ArrayList();

    public PackageTemplateReader(InputStream in, ITemplateExtension extension) {
        super(in, extension);
    }

    protected TemplateSource createSource() {
        PackageTemplateSource source = new PackageTemplateSource();
        source.setCompilationUnits(this.getCompilationUnits());
        return source;
    }

    public UnitElement[] getCompilationUnits() {
        return this.units.toArray(new UnitElement[this.units.size()]);
    }

    protected void addElement(Element element) throws IOException {
        String name = element.getNodeName();
        if ("unit".equals(name)) {
            this.addUnit(element);
        } else {
            super.addElement(element);
        }
    }

    private void addUnit(Element element) throws IOException {
        String name = element.getAttribute("name");
        String fragment = element.getAttribute("package");
        String contents = this.getContents(element);
        if (name == null || contents == null) {
            throw new IOException("missing unit markup");
        }
        this.units.add(new UnitElement(Templates.createSnippet(name), Templates.createSnippet(contents), Templates.createSnippet(fragment)));
    }
}

