/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.IPackageTemplateSource;
import com.tssap.selena.cmf.internal.templates.TemplateContext;
import com.tssap.selena.cmf.internal.templates.UnitElement;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.TemplateException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class PackageTemplateContext
extends TemplateContext {
    private IPackageTemplateSource source;
    private IPackageFragment[] myTargets;

    public void init(ITemplate template, Object[] selection) throws CoreException {
        this.source = (IPackageTemplateSource)template.getSource();
        this.myTargets = null;
        super.init(template, selection);
    }

    public void apply(IProgressMonitor monitor) throws CoreException {
        String error = this.isValid();
        if (error != null) {
            throw new TemplateException(error);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IPackageFragment[] targets = this.getTargets();
        try {
            monitor.beginTask(this.template.getName(), targets.length);
            int i = 0;
            while (i < targets.length) {
                this.work(targets[i]);
                monitor.worked(1);
                ++i;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected IPackageFragment[] getTargets() throws CoreException {
        if (this.myTargets == null) {
            ArrayList<Object> types = new ArrayList<Object>();
            int i = 0;
            while (i < this.selection.length) {
                Object element = this.selection[i];
                if (element instanceof IPackageFragment) {
                    types.add(element);
                } else if (element instanceof IJavaProject) {
                    this.addTargets(types, (IJavaProject)element);
                } else {
                    throw new TemplateException("illegal selection element: " + element);
                }
                ++i;
            }
            this.myTargets = types.toArray(new IPackageFragment[types.size()]);
        }
        return this.myTargets;
    }

    private void addTargets(ArrayList types, IJavaProject project) throws CoreException {
        IPackageFragmentRoot[] pfr = project.getPackageFragmentRoots();
        int i = 0;
        while (i < pfr.length) {
            if (pfr[i].getKind() == 1) {
                types.add(pfr[i].getPackageFragment(""));
            }
            ++i;
        }
    }

    public String isValid() {
        String valid = super.isValid();
        if (valid != null) {
            return valid;
        }
        try {
            IPackageFragment[] targets = this.getTargets();
            int i = 0;
            while (i < targets.length) {
                valid = this.isValid(targets[i]);
                if (valid != null) {
                    return valid;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            return e.getMessage();
        }
        return null;
    }

    private String isValid(IPackageFragment target) throws CoreException {
        ISnippetContext context = this.createSnippetContext();
        PackageTemplateContext.addPackageVariables(context, target);
        UnitElement[] sourceUnits = this.source.getCompilationUnits();
        ICompilationUnit[] targetUnits = target.getCompilationUnits();
        int i = 0;
        while (i < sourceUnits.length) {
            UnitElement ue = sourceUnits[i];
            String name = TemplateContext.format(ue.getName(), context);
            ICompilationUnit unit = this.findUnit(targetUnits, name + ".java");
            if (unit != null) {
                return name + " compilation unit already exist in " + target.getElementName();
            }
            ++i;
        }
        return null;
    }

    private ICompilationUnit findUnit(ICompilationUnit[] units, String name) {
        int i = 0;
        while (i < units.length) {
            if (name.equals(units[i].getElementName())) {
                return units[i];
            }
            ++i;
        }
        return null;
    }

    private void work(IPackageFragment target) throws CoreException {
        ISnippetContext context = this.createSnippetContext();
        PackageTemplateContext.addPackageVariables(context, target);
        String packageName = target.getElementName();
        String packageStmt = target.isDefaultPackage() ? null : "package " + packageName + ";\n";
        UnitElement[] units = this.source.getCompilationUnits();
        int i = 0;
        while (i < units.length) {
            UnitElement ue = units[i];
            String name = TemplateContext.format(ue.getName(), context);
            context.addVariable("className", name);
            String code = ue.getContents().render(context);
            if (packageStmt != null) {
                code = packageStmt + code;
            }
            code = CodeToolkit.format(code, 0);
            this.createCompilationUnit(target, name, code);
            ++i;
        }
    }

    protected void createCompilationUnit(IPackageFragment target, String name, String code) throws CoreException {
        target.createCompilationUnit(name + ".java", code, false, null);
    }

    public static void addPackageVariables(ISnippetContext context, IPackageFragment target) throws CoreException {
        String packageName = target.getElementName();
        String packageQualifier = packageName.length() == 0 ? packageName : packageName + ".";
        context.addVariable("packageName", packageName);
        context.addVariable("packageQualifier", packageQualifier);
    }
}

