/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodePlugin;
import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.LocalTemplate;
import com.tssap.selena.cmf.internal.templates.LocalTemplateCategory;
import com.tssap.selena.cmf.internal.templates.LocalTemplateProject;
import com.tssap.selena.cmf.internal.templates.TemplateBundle;
import com.tssap.selena.cmf.internal.templates.TemplateManager;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateProject;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalTemplateManager
extends TemplateManager {
    private static final String ROOT_FOLDER = "templates";
    private static final String DEFAULT_CATEGORY = "Misc";
    private static File templatesDirectory;
    protected File directory;
    protected ITemplateCategory category;
    private LocalTemplateProject project;

    public LocalTemplateManager(ITemplateExtension extension, LocalTemplateProject project) {
        super(extension);
        this.project = project;
        this.initTemplates();
    }

    public ITemplateProject getProject() {
        return this.project;
    }

    private void initTemplates() {
        try {
            File dir = this.getTemplateDirectory();
            if (dir.exists()) {
                File[] members = dir.listFiles();
                int i = 0;
                while (i < members.length) {
                    File member = members[i];
                    if (member.isDirectory()) {
                        this.addTemplateCategory(member);
                    }
                    ++i;
                }
            } else {
                this.loadTemplateBundle(dir);
            }
        }
        catch (Exception e) {
            CodePlugin.error("error loading templates", e);
        }
    }

    private void addTemplateCategory(File dir) throws IOException {
        LocalTemplateCategory category = this.createTemplateCategory(dir.getName());
        File[] members = dir.listFiles();
        int i = 0;
        while (i < members.length) {
            File member = members[i];
            if (member.isFile()) {
                this.addTemplateFile(category, member);
            }
            ++i;
        }
    }

    private void addTemplateFile(LocalTemplateCategory category, File file) {
        String ext = CodeToolkit.getFileExtension(file.getName());
        if ("template".equals(ext)) {
            try {
                ITemplate template = this.loadTemplate(category, file);
                category.addTemplate(template);
            }
            catch (Exception e) {
                CodePlugin.error("cannot load template from " + file, e);
            }
        }
    }

    private ITemplate loadTemplate(LocalTemplateCategory category, File file) throws CoreException {
        try {
            ITemplateSource source = this.extension.loadSource(new FileInputStream(file));
            LocalTemplate template = new LocalTemplate(category, file);
            template.setSource(source);
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private File getTemplateDirectory() throws IOException {
        if (this.directory == null) {
            this.directory = new File(LocalTemplateManager.getTemplatesDirectory(), this.extension.getStore());
        }
        return this.directory;
    }

    private void loadTemplateBundle(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("cannot create local template directory");
        }
        TemplateBundle bundle = new TemplateBundle(this.extension);
        ITemplateCategory[] categories = bundle.getCategories();
        int i = 0;
        while (i < categories.length) {
            ITemplateCategory bundleCategory = categories[i];
            LocalTemplateCategory localCategory = this.createTemplateCategory(bundleCategory.getName());
            ITemplate[] bundleTemplates = bundleCategory.getTemplates();
            int j = 0;
            while (j < bundleTemplates.length) {
                ITemplate template = bundleTemplates[j];
                try {
                    localCategory.createTemplate(template.getName(), template.getSource(), null);
                }
                catch (CoreException e) {
                    CodePlugin.error("cannot copy builtin template", e);
                }
                ++j;
            }
            ++i;
        }
    }

    public static File getTemplatesDirectory() throws IOException {
        IPath path;
        if (templatesDirectory == null && !(templatesDirectory = (path = CodePlugin.getInstance().getStateLocation()).append("templates/").toFile()).exists() && !templatesDirectory.mkdirs()) {
            throw new IOException();
        }
        return templatesDirectory;
    }

    public ITemplateCategory getDefaultCategory() {
        try {
            return this.createTemplateCategory(DEFAULT_CATEGORY);
        }
        catch (Exception e) {
            CodePlugin.warn("error creating template category", e);
            return null;
        }
    }

    public ITemplateCategory createCategory(String name, IProgressMonitor monitor) throws CoreException {
        try {
            return this.createTemplateCategory(name);
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private LocalTemplateCategory createTemplateCategory(String name) throws IOException {
        LocalTemplateCategory category = this.getTemplateCategory(name);
        if (category == null) {
            File file = new File(this.getTemplateDirectory(), name);
            category = new LocalTemplateCategory(this, file);
            category.create();
            this.addCategory(category);
        }
        return category;
    }

    private LocalTemplateCategory getTemplateCategory(String name) {
        ITemplateCategory[] categories = this.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (name.equals(categories[i].getName())) {
                return (LocalTemplateCategory)categories[i];
            }
            ++i;
        }
        return null;
    }
}

