/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.LocalTemplate;
import com.tssap.selena.cmf.internal.templates.LocalTemplateManager;
import com.tssap.selena.cmf.internal.templates.Messages;
import com.tssap.selena.cmf.internal.templates.TemplateCategory;
import com.tssap.selena.cmf.templates.ITemplate;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.ITemplateManager;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalTemplateCategory
extends TemplateCategory {
    private File folder;
    private LocalTemplateManager manager;

    public LocalTemplateCategory(LocalTemplateManager manager, File folder) {
        super(folder.getName());
        this.folder = folder;
        this.manager = manager;
    }

    public ITemplateManager getManager() {
        return this.manager;
    }

    public File getFolder() {
        return this.folder;
    }

    public void create() throws IOException {
        if (!this.folder.exists() && !this.folder.mkdir()) {
            throw new IOException(Messages.getString("cannot_create_diretory__1") + this.folder.toString());
        }
    }

    public ITemplate createTemplate(String name, ITemplateSource source, IProgressMonitor monitor) throws CoreException {
        try {
            ITemplateExtension extension = this.manager.getExtension();
            File file = new File(this.folder, name + ".template");
            extension.saveSource(new FileOutputStream(file), source);
            LocalTemplate template = (LocalTemplate)this.findTemplate(name);
            if (template == null) {
                template = new LocalTemplate(this, file);
                template.setSource(source);
                this.addTemplate(template);
            } else {
                template.setSource(source);
            }
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public void rename(String name, IProgressMonitor monitor) throws CoreException {
        if (this.folder == null) {
            throw new IllegalStateException();
        }
        File parent = this.folder.getParentFile();
        File dest = new File(parent, name);
        if (!this.folder.renameTo(dest)) {
            throw new TemplateException(Messages.getString("cannot_rename_file__2") + this.folder);
        }
        ITemplate[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            ((LocalTemplate)templates[i]).move(dest);
            ++i;
        }
        this.name = name;
        this.folder = dest;
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        if (this.folder == null) {
            throw new IllegalStateException();
        }
        if (!LocalTemplateCategory.deleteDirectory(this.folder)) {
            throw new TemplateException(Messages.getString("cannot_delete_file__3") + this.folder);
        }
        if (this.manager != null) {
            this.manager.removeCategory(this);
        }
    }

    private static boolean deleteDirectory(File dir) {
        File[] members = dir.listFiles();
        int i = 0;
        while (i < members.length) {
            File member = members[i];
            if (member.isDirectory() ? !LocalTemplateCategory.deleteDirectory(member) : !member.delete()) {
                return false;
            }
            ++i;
        }
        return dir.delete();
    }
}

