/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.CodeToolkit;
import com.tssap.selena.cmf.internal.templates.LocalTemplateCategory;
import com.tssap.selena.cmf.internal.templates.Messages;
import com.tssap.selena.cmf.internal.templates.Template;
import com.tssap.selena.cmf.internal.templates.TemplateModel;
import com.tssap.selena.cmf.templates.ITemplateCategory;
import com.tssap.selena.cmf.templates.ITemplateSource;
import com.tssap.selena.cmf.templates.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalTemplate
extends Template {
    private static final String HISTORY_EXTENSION = "~";
    private LocalTemplateCategory category;
    private File file;
    private String name;
    private String path;

    public LocalTemplate(LocalTemplateCategory category, File file) {
        this.category = category;
        this.file = file;
        this.path = file.getPath();
        this.name = CodeToolkit.getFileStem(file.getName());
    }

    void move(File parent) {
        this.file = new File(parent, this.file.getName());
    }

    public ITemplateCategory getCategory() {
        return this.category;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof LocalTemplate && this.equals((LocalTemplate)o);
    }

    private boolean equals(LocalTemplate that) {
        return this.file.equals(that.file);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void save(ITemplateSource source, IProgressMonitor monitor) throws CoreException {
        try {
            this.createHistory();
            this.getExtension().saveSource(new FileOutputStream(this.file), source);
            this.setSource(source);
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    public void rename(String name, IProgressMonitor monitor) throws CoreException {
        if (this.file == null) {
            throw new IllegalStateException();
        }
        File parent = this.file.getParentFile();
        File dest = new File(parent, name + ".template");
        if (!this.file.renameTo(dest)) {
            throw new TemplateException(Messages.getString("cannot_rename_file__1") + this.file);
        }
        File history = LocalTemplate.getHistoryFile(this.file);
        if (history.exists()) {
            history.renameTo(LocalTemplate.getHistoryFile(dest));
        }
        this.name = name;
        this.file = dest;
        this.path = dest.getPath();
        TemplateModel.projectChanged(this.getManager().getProject());
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        if (this.file == null) {
            throw new IllegalStateException();
        }
        if (!this.file.delete()) {
            throw new TemplateException(Messages.getString("cannot_delete_file__2") + this.file);
        }
        File history = LocalTemplate.getHistoryFile(this.file);
        if (history.exists()) {
            history.delete();
        }
        if (this.category != null) {
            this.category.removeTemplate(this);
        }
    }

    public boolean hasHistory() {
        return LocalTemplate.getHistoryFile(this.file).exists();
    }

    public void restoreHistory() throws CoreException {
        try {
            File history = LocalTemplate.getHistoryFile(this.file);
            ITemplateSource source = this.getExtension().loadSource(new FileInputStream(history));
            if (!this.file.delete()) {
                throw new TemplateException(Messages.getString("cannot_delete_file__2") + this.file);
            }
            if (!history.renameTo(this.file)) {
                throw new TemplateException(Messages.getString("cannot_delete_file__2") + this.file);
            }
            this.setSource(source);
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private void createHistory() {
        File dest = LocalTemplate.getHistoryFile(this.file);
        if (!dest.exists()) {
            this.file.renameTo(dest);
        }
    }

    private static File getHistoryFile(File file) {
        File parent = file.getParentFile();
        return new File(parent, file.getName() + HISTORY_EXTENSION);
    }
}

