/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.IClassTemplateSource;
import com.tssap.selena.cmf.internal.templates.IConstants;
import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import org.eclipse.core.runtime.CoreException;

public class ClassTemplateSource
extends TemplateSource
implements IClassTemplateSource {
    protected ISnippet[] imports;
    protected SourceElement[] types;
    protected SourceElement[] fields;
    protected SourceElement[] methods;
    protected boolean iface;

    public ClassTemplateSource() {
        this.imports = IConstants.EMPTY_SNIPPETS;
        this.types = IConstants.EMPTY_SOURCES;
        this.fields = IConstants.EMPTY_SOURCES;
        this.methods = IConstants.EMPTY_SOURCES;
    }

    public ClassTemplateSource(ClassTemplateSource source) {
        super(source);
        ISnippet[] imports = source.getImports();
        this.imports = new ISnippet[imports.length];
        System.arraycopy(imports, 0, this.imports, 0, imports.length);
        this.types = TemplateSource.copy(source.getTypes());
        this.fields = TemplateSource.copy(source.getFields());
        this.methods = TemplateSource.copy(source.getMethods());
        this.iface = source.isInterface();
    }

    public String toString() {
        return "<ClassTemplateSource variables=" + this.getVariables() + " imports=" + this.imports + " />";
    }

    public ISnippet[] getImports() {
        return this.imports;
    }

    public void setImports(ISnippet[] imports) {
        this.imports = imports;
    }

    public SourceElement[] getTypes() {
        return this.types;
    }

    public void setTypes(SourceElement[] types) {
        this.types = types;
    }

    public SourceElement[] getFields() {
        return this.fields;
    }

    public void setFields(SourceElement[] fields) {
        this.fields = fields;
    }

    public SourceElement[] getMethods() {
        return this.methods;
    }

    public void setMethods(SourceElement[] methods) {
        this.methods = methods;
    }

    public boolean isInterface() {
        return this.iface;
    }

    public void setInterface(boolean iface) {
        this.iface = iface;
    }

    protected ISnippetContext createSnippetContext() {
        ISnippetContext context = super.createSnippetContext();
        context.addVariable("fieldName", "");
        context.addVariable("methodName", "");
        return context;
    }

    protected void validate(ISnippetContext context) throws CoreException {
        this.validateSnippets(context, this.getImports());
        this.validateSnippets(context, this.getTypes());
        this.validateSnippets(context, this.getFields());
        this.validateSnippets(context, this.getMethods());
    }
}

