/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.ClassTemplateSource;
import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateReader;
import com.tssap.selena.cmf.internal.templates.TemplateSource;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ITemplateExtension;
import com.tssap.selena.cmf.templates.Templates;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class ClassTemplateReader
extends TemplateReader {
    protected ArrayList imports = new ArrayList();
    protected ArrayList types = new ArrayList();
    protected ArrayList fields = new ArrayList();
    protected ArrayList methods = new ArrayList();
    protected boolean isInterface;

    public ClassTemplateReader(InputStream in, ITemplateExtension extension) {
        super(in, extension);
    }

    public TemplateSource createSource() {
        ClassTemplateSource source = new ClassTemplateSource();
        source.setImports(this.getImports());
        source.setTypes(this.getTypes());
        source.setFields(this.getFields());
        source.setMethods(this.getMethods());
        source.setInterface(this.isInterface());
        return source;
    }

    public ISnippet[] getImports() {
        return this.imports.toArray(new ISnippet[this.imports.size()]);
    }

    public SourceElement[] getTypes() {
        return this.types.toArray(new SourceElement[this.types.size()]);
    }

    public SourceElement[] getFields() {
        return this.fields.toArray(new SourceElement[this.fields.size()]);
    }

    public SourceElement[] getMethods() {
        return this.methods.toArray(new SourceElement[this.methods.size()]);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    protected void addElement(Element element) throws IOException {
        String name = element.getNodeName();
        if ("type".equals(name)) {
            this.addType(element);
        } else if ("import".equals(name)) {
            this.addImport(element);
        } else if ("field".equals(name)) {
            this.addField(element);
        } else if ("method".equals(name)) {
            this.addMethod(element);
        } else if ("isInterface".equals(name)) {
            this.isInterface = true;
        } else {
            super.addElement(element);
        }
    }

    private void addImport(Element element) throws IOException {
        this.addSnippet(this.imports, element);
    }

    private void addType(Element element) throws IOException {
        this.addSource(this.types, element, "Type");
    }

    private void addField(Element element) throws IOException {
        this.addSource(this.fields, element, "field");
    }

    private void addMethod(Element element) throws IOException {
        this.addSource(this.methods, element, "method");
    }

    private void addSnippet(ArrayList list, Element element) throws IOException {
        String contents = this.getContents(element);
        if (contents == null) {
            throw new IOException("illegal contents: " + element);
        }
        list.add(Templates.createSnippet(contents));
    }

    private void addSource(ArrayList list, Element element, String prefix) throws IOException {
        String contents;
        String name = element.getAttribute("name");
        if (name == null || name.length() == 0) {
            name = prefix + list.size();
        }
        if ((contents = this.getContents(element)) == null) {
            throw new IOException("missing source contents");
        }
        list.add(new SourceElement(Templates.createSnippet(name), Templates.createSnippet(contents)));
    }
}

