/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.cmf.internal.templates;

import com.tssap.selena.cmf.internal.templates.IClassTemplateSource;
import com.tssap.selena.cmf.internal.templates.Messages;
import com.tssap.selena.cmf.internal.templates.SourceElement;
import com.tssap.selena.cmf.internal.templates.TemplateContext;
import com.tssap.selena.cmf.internal.templates.TypeTemplateContext;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.ITemplate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class ClassTemplateContext
extends TypeTemplateContext {
    private IClassTemplateSource source;

    public void init(ITemplate template, Object[] selection) throws CoreException {
        this.source = (IClassTemplateSource)template.getSource();
        super.init(template, selection);
    }

    public String isValid() {
        String valid = super.isValid();
        if (valid != null) {
            return valid;
        }
        try {
            IType[] targets = this.getTargets();
            boolean iface = this.source.isInterface();
            int i = 0;
            while (i < targets.length) {
                if (iface != targets[i].isInterface()) {
                    return iface ? Messages.getString("ClassTemplateContext.typeApplicableToInterface") : Messages.getString("ClassTemplateContext.TypeApplicableToClass");
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < targets.length) {
                valid = this.isValid(targets[i2]);
                if (valid != null) {
                    return valid;
                }
                ++i2;
            }
        }
        catch (CoreException e) {
            return e.getMessage();
        }
        return null;
    }

    private String isValid(IType target) throws CoreException {
        ISnippetContext context = this.createSnippetContext(target);
        IField[] targetFields = target.getFields();
        SourceElement[] sourceFields = this.source.getFields();
        int i = 0;
        while (i < sourceFields.length) {
            SourceElement element = sourceFields[i];
            String name = TemplateContext.format(element.getName(), context);
            IField field = this.findField(targetFields, name);
            if (field != null) {
                return name + Messages.getString("_field_already_exist_in__1") + target.getFullyQualifiedName();
            }
            ++i;
        }
        IMethod[] targetMethods = target.getMethods();
        SourceElement[] sourceMethods = this.source.getMethods();
        int i2 = 0;
        while (i2 < sourceMethods.length) {
            SourceElement element = sourceMethods[i2];
            String name = TemplateContext.format(element.getName(), context);
            IMethod method = this.findMethod(targetMethods, name);
            if (method != null) {
                return name + Messages.getString("_method_already_exist_in__2") + target.getFullyQualifiedName();
            }
            ++i2;
        }
        return null;
    }

    private IField findField(IField[] fields, String name) {
        int i = 0;
        while (i < fields.length) {
            if (name.equals(fields[i].getElementName())) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private IMethod findMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            if (name.equals(methods[i].getElementName())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    protected void work(IType type) throws CoreException {
        String code;
        String name;
        ISnippetContext context = this.createSnippetContext(type);
        ISnippet[] imports = this.source.getImports();
        SourceElement[] fields = this.source.getFields();
        SourceElement[] methods = this.source.getMethods();
        SourceElement[] types = this.source.getTypes();
        ICompilationUnit unit = type.getCompilationUnit();
        int i = 0;
        while (i < imports.length) {
            String code2 = TemplateContext.format(imports[i], context);
            unit.createImport(code2, null, null);
            ++i;
        }
        int i2 = 0;
        while (i2 < fields.length) {
            SourceElement element = fields[i2];
            String name2 = TemplateContext.format(element.getName(), context);
            context.addVariable("fieldName", name2);
            String code3 = TemplateContext.format(element.getContents(), context, 1);
            type.createField(code3, null, false, null);
            ++i2;
        }
        int i3 = 0;
        while (i3 < methods.length) {
            SourceElement element = methods[i3];
            name = TemplateContext.format(element.getName(), context);
            context.addVariable("methodName", name);
            code = TemplateContext.format(element.getContents(), context, 1);
            type.createMethod(code, null, false, null);
            ++i3;
        }
        int i4 = 0;
        while (i4 < types.length) {
            name = TemplateContext.format(types[i4].getName(), context);
            context.addVariable("typeName", name);
            code = TemplateContext.format(types[i4].getContents(), context, 1);
            type.createType(code, null, false, null);
            ++i4;
        }
    }
}

